/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.security.AccessController;

class KeyInput {
    private static KeyInput instance = new KeyInput();
    private KeyState state = new KeyState();
    private IntSet keys = new IntSet();
    private boolean numLock = false;
    private boolean capsLock = false;
    private char[] NO_CHAR = new char[0];

    KeyInput() {
    }

    static KeyInput getInstance() {
        return instance;
    }

    void getState(KeyState keyState) {
        this.state.copyTo(keyState);
    }

    void setState(KeyState keyState) {
        int n;
        int n2;
        if (MonocleSettings.settings.traceEvents) {
            MonocleTrace.traceEvent("Set %s", keyState);
        }
        keyState.getWindow(true);
        this.state.getKeysPressed().difference(this.keys, keyState.getKeysPressed());
        if (!this.keys.isEmpty()) {
            for (n2 = 0; n2 < this.keys.size(); ++n2) {
                n = this.keys.get(n2);
                this.dispatchKeyEvent(keyState, 112, n);
            }
        }
        this.keys.clear();
        keyState.getKeysPressed().difference(this.keys, this.state.getKeysPressed());
        if (!this.keys.isEmpty()) {
            for (n2 = 0; n2 < this.keys.size(); ++n2) {
                n = this.keys.get(n2);
                if (n == 20) {
                    this.capsLock = !this.capsLock;
                } else if (n == 144) {
                    this.numLock = !this.numLock;
                } else if (n == 67 && keyState.isControlPressed()) {
                    AccessController.doPrivileged(() -> {
                        if ("1".equals(System.getenv("JAVAFX_DEBUG"))) {
                            System.exit(0);
                        }
                        return null;
                    });
                }
                this.dispatchKeyEvent(keyState, 111, n);
            }
        }
        this.keys.clear();
        keyState.copyTo(this.state);
    }

    private void dispatchKeyEvent(KeyState keyState, int n, int n2) {
        MonocleWindow monocleWindow = keyState.getWindow(false);
        if (monocleWindow == null) {
            return;
        }
        MonocleView monocleView = (MonocleView)monocleWindow.getView();
        if (monocleView == null) {
            return;
        }
        char[] cArray = this.getKeyChars(keyState, n2);
        int n3 = keyState.getModifiers();
        RunnableProcessor.runLater(() -> monocleView.notifyKey(n, n2, cArray, n3));
        if (n == 111 && cArray.length > 0) {
            RunnableProcessor.runLater(() -> monocleView.notifyKey(113, n2, cArray, n3));
        }
    }

    private char[] getKeyChars(KeyState keyState, int n) {
        char[] cArray;
        int n2 = 0;
        boolean bl = keyState.isShiftPressed();
        if (n >= 65 && n <= 90) {
            n2 = (bl ^= this.capsLock) ? (int)((char)(n - 65 + 65)) : (int)((char)(n - 65 + 97));
        } else if (n >= 96 && n <= 105) {
            if (this.numLock) {
                n2 = (char)(n - 96 + 48);
            }
        } else if (n >= 48 && n <= 57) {
            if (bl) {
                switch (n) {
                    case 48: {
                        n2 = 41;
                        break;
                    }
                    case 49: {
                        n2 = 33;
                        break;
                    }
                    case 50: {
                        n2 = 64;
                        break;
                    }
                    case 51: {
                        n2 = 35;
                        break;
                    }
                    case 52: {
                        n2 = 36;
                        break;
                    }
                    case 53: {
                        n2 = 37;
                        break;
                    }
                    case 54: {
                        n2 = 94;
                        break;
                    }
                    case 55: {
                        n2 = 38;
                        break;
                    }
                    case 56: {
                        n2 = 42;
                        break;
                    }
                    case 57: {
                        n2 = 40;
                    }
                }
            } else {
                n2 = (char)(n - 48 + 48);
            }
        } else if (n == 32) {
            n2 = 32;
        } else if (n == 9) {
            n2 = 9;
        } else if (n == 10) {
            n2 = 10;
        } else if (n == 106) {
            n2 = 42;
        } else if (n == 111) {
            n2 = 47;
        } else if (bl) {
            switch (n) {
                case 192: {
                    n2 = 126;
                    break;
                }
                case 44: {
                    n2 = 60;
                    break;
                }
                case 46: {
                    n2 = 62;
                    break;
                }
                case 47: {
                    n2 = 63;
                    break;
                }
                case 59: {
                    n2 = 58;
                    break;
                }
                case 222: {
                    n2 = 34;
                    break;
                }
                case 161: {
                    n2 = 123;
                    break;
                }
                case 162: {
                    n2 = 125;
                    break;
                }
                case 92: {
                    n2 = 124;
                    break;
                }
                case 45: {
                    n2 = 95;
                    break;
                }
                case 61: {
                    n2 = 43;
                }
            }
        } else {
            switch (n) {
                case 192: {
                    n2 = 96;
                    break;
                }
                case 44: {
                    n2 = 44;
                    break;
                }
                case 46: {
                    n2 = 46;
                    break;
                }
                case 47: {
                    n2 = 47;
                    break;
                }
                case 59: {
                    n2 = 59;
                    break;
                }
                case 222: {
                    n2 = 39;
                    break;
                }
                case 161: {
                    n2 = 91;
                    break;
                }
                case 162: {
                    n2 = 93;
                    break;
                }
                case 92: {
                    n2 = 92;
                    break;
                }
                case 45: {
                    n2 = 45;
                    break;
                }
                case 61: {
                    n2 = 61;
                }
            }
        }
        if (n2 == 0) {
            cArray = this.NO_CHAR;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = n2;
        }
        return cArray;
    }

    int getKeyCodeForChar(char c) {
        c = Character.toUpperCase(c);
        switch (c) {
            case '!': {
                c = (char)49;
                break;
            }
            case '@': {
                c = (char)50;
                break;
            }
            case '#': {
                c = (char)51;
                break;
            }
            case '$': {
                c = (char)52;
                break;
            }
            case '%': {
                c = (char)53;
                break;
            }
            case '^': {
                c = (char)54;
                break;
            }
            case '&': {
                c = (char)55;
                break;
            }
            case '*': {
                c = (char)56;
                break;
            }
            case '(': {
                c = (char)57;
                break;
            }
            case ')': {
                c = (char)48;
                break;
            }
            case '~': {
                c = (char)96;
                break;
            }
            case '_': {
                c = (char)45;
                break;
            }
            case '+': {
                c = (char)61;
                break;
            }
            case '{': {
                c = (char)91;
                break;
            }
            case '}': {
                c = (char)93;
                break;
            }
            case '|': {
                c = (char)92;
                break;
            }
            case ':': {
                c = (char)59;
                break;
            }
            case '\"': {
                c = (char)39;
                break;
            }
            case '<': {
                c = (char)44;
                break;
            }
            case '>': {
                c = (char)46;
                break;
            }
            case '?': {
                c = (char)47;
            }
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 65;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 48;
        }
        switch (c) {
            case '`': {
                return 192;
            }
            case '-': {
                return 45;
            }
            case '=': {
                return 61;
            }
            case '[': {
                return 161;
            }
            case ']': {
                return 162;
            }
            case '\\': {
                return 92;
            }
            case ';': {
                return 59;
            }
            case '\'': {
                return 222;
            }
            case ',': {
                return 44;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
        }
        return 0;
    }
}

