/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;

class KeyState {
    private IntSet keysPressed = new IntSet();
    private MonocleWindow window;
    private int modifiers;

    KeyState() {
    }

    void clear() {
        this.keysPressed.clear();
        this.modifiers = 0;
    }

    void pressKey(int n) {
        this.keysPressed.addInt(n);
        this.modifiers |= KeyState.getModifier(n);
    }

    void releaseKey(int n) {
        this.keysPressed.removeInt(n);
        this.modifiers &= ~KeyState.getModifier(n);
    }

    void copyTo(KeyState keyState) {
        this.keysPressed.copyTo(keyState.keysPressed);
        keyState.window = this.window;
        keyState.modifiers = this.modifiers;
    }

    IntSet getKeysPressed() {
        return this.keysPressed;
    }

    MonocleWindow getWindow(boolean bl) {
        if (this.window == null || bl) {
            this.window = MonocleWindowManager.getInstance().getFocusedWindow();
        }
        return this.window;
    }

    private static int getModifier(int n) {
        switch (n) {
            case 16: {
                return 1;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 768: {
                return 16;
            }
            case 524: {
                return 16;
            }
        }
        return 0;
    }

    int getModifiers() {
        return this.modifiers;
    }

    boolean isShiftPressed() {
        return (this.modifiers & 1) != 0;
    }

    boolean isControlPressed() {
        return (this.modifiers & 4) != 0;
    }

    public String toString() {
        return "KeyState[modifiers=" + this.modifiers + ",keys=" + this.keysPressed + "]";
    }
}

