/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;

class LinuxMouseProcessor
implements LinuxInputProcessor {
    private MouseInput mouse = MouseInput.getInstance();
    private MouseState previousState = new MouseState();
    private MouseState state = new MouseState();
    private boolean hasPendingState;

    LinuxMouseProcessor() {
    }

    @Override
    public void processEvents(LinuxInputDevice linuxInputDevice) {
        LinuxEventBuffer linuxEventBuffer = linuxInputDevice.getBuffer();
        this.mouse.getState(this.previousState);
        this.mouse.getState(this.state);
        this.hasPendingState = false;
        while (linuxEventBuffer.hasNextEvent()) {
            block0 : switch (linuxEventBuffer.getEventType()) {
                case 2: {
                    int n;
                    switch (linuxEventBuffer.getEventCode()) {
                        case 0: {
                            n = this.previousState.getX();
                            this.state.setX(n += linuxEventBuffer.getEventValue());
                            break block0;
                        }
                        case 1: {
                            int n2 = this.previousState.getY();
                            this.state.setY(n2 += linuxEventBuffer.getEventValue());
                            break block0;
                        }
                        case 8: {
                            int n3 = linuxEventBuffer.getEventValue();
                            if (n3 < 0) {
                                this.state.setWheel(-1);
                                break block0;
                            }
                            if (n3 > 0) {
                                this.state.setWheel(1);
                                break block0;
                            }
                            this.state.setWheel(0);
                            break block0;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (linuxEventBuffer.getEventCode()) {
                        case 0: {
                            this.sendEvent();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    int n = LinuxMouseProcessor.mouseButtonForKeyCode(linuxEventBuffer.getEventCode());
                    if (n < 0) break;
                    if (linuxEventBuffer.getEventValue() == 0) {
                        this.state.releaseButton(n);
                        break;
                    }
                    this.state.pressButton(n);
                    break;
                }
            }
            linuxEventBuffer.nextEvent();
        }
        if (this.hasPendingState) {
            this.mouse.setState(this.previousState, false);
        }
    }

    private void sendEvent() {
        if (this.state.canBeFoldedWith(this.previousState)) {
            this.hasPendingState = true;
        } else {
            if (this.hasPendingState) {
                this.mouse.setState(this.previousState, false);
                this.hasPendingState = false;
            }
            this.mouse.setState(this.state, false);
        }
        this.state.copyTo(this.previousState);
    }

    private static int mouseButtonForKeyCode(int n) {
        switch (n) {
            case 272: {
                return 212;
            }
            case 274: {
                return 214;
            }
            case 273: {
                return 213;
            }
        }
        return -1;
    }
}

