/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxTouchProcessor;
import com.sun.glass.ui.monocle.LookaheadTouchFilter;
import com.sun.glass.ui.monocle.TouchState;
import java.util.HashMap;
import java.util.Map;

class LinuxStatefulMultiTouchProcessor
extends LinuxTouchProcessor {
    private static final int ID_UNASSIGNED = -1;
    private static final int COORD_UNDEFINED = Integer.MIN_VALUE;
    private int currentID = -1;
    private int currentSlot = 0;
    private final Map<Integer, Integer> slotToIDMap = new HashMap<Integer, Integer>();

    LinuxStatefulMultiTouchProcessor(LinuxInputDevice linuxInputDevice) {
        super(linuxInputDevice);
        this.pipeline.addFilter(new LookaheadTouchFilter(false));
    }

    @Override
    public void processEvents(LinuxInputDevice linuxInputDevice) {
        LinuxEventBuffer linuxEventBuffer = linuxInputDevice.getBuffer();
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        boolean bl = false;
        while (linuxEventBuffer.hasNextEvent()) {
            block0 : switch (linuxEventBuffer.getEventType()) {
                case 3: {
                    int n3 = this.transform.getValue(linuxEventBuffer);
                    switch (this.transform.getAxis(linuxEventBuffer)) {
                        case 47: {
                            if (this.currentID != -1 && (n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE)) {
                                this.updatePoint(n, n2);
                                n2 = Integer.MIN_VALUE;
                                n = Integer.MIN_VALUE;
                            }
                            this.currentSlot = n3;
                            this.currentID = this.slotToIDMap.getOrDefault(this.currentSlot, -1);
                            break;
                        }
                        case 57: {
                            if (n3 == -1 && this.currentID != -1) {
                                this.state.removePointForID(this.currentID);
                            }
                            this.currentID = n3;
                            if (this.currentID == -1) {
                                this.slotToIDMap.remove(this.currentSlot);
                                break;
                            }
                            this.slotToIDMap.put(this.currentSlot, this.currentID);
                            break;
                        }
                        case 0: 
                        case 53: {
                            if (n != Integer.MIN_VALUE) break;
                            n = n3;
                            break;
                        }
                        case 1: 
                        case 54: {
                            if (n2 != Integer.MIN_VALUE) break;
                            n2 = n3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (linuxEventBuffer.getEventCode()) {
                        case 330: {
                            if (linuxEventBuffer.getEventValue() != 0) break;
                            bl = true;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (linuxEventBuffer.getEventCode()) {
                        case 2: {
                            if (this.currentID != -1) {
                                if (n == Integer.MIN_VALUE && n2 == Integer.MIN_VALUE) {
                                    this.state.removePointForID(this.currentID);
                                    this.currentID = -1;
                                } else {
                                    this.updatePoint(n, n2);
                                }
                            }
                            n2 = Integer.MIN_VALUE;
                            n = Integer.MIN_VALUE;
                            break block0;
                        }
                        case 0: {
                            if ((n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE) && this.currentID != -1) {
                                this.updatePoint(n, n2);
                            } else if (bl) {
                                this.state.clear();
                            }
                            this.pipeline.pushState(this.state);
                            n2 = Integer.MIN_VALUE;
                            n = Integer.MIN_VALUE;
                            bl = false;
                            break block0;
                        }
                    }
                }
            }
            linuxEventBuffer.nextEvent();
        }
        this.pipeline.flush();
    }

    private void updatePoint(int n, int n2) {
        TouchState.Point point = this.state.getPointForID(this.currentID);
        if (point == null) {
            point = new TouchState.Point();
            point.id = this.currentID;
            point = this.state.addPoint(point);
        }
        if (n != Integer.MIN_VALUE) {
            point.x = n;
        }
        if (n2 != Integer.MIN_VALUE) {
            point.y = n2;
        }
    }
}

