/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.HeadlessScreen;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;

class VNCScreen
extends HeadlessScreen {
    private ServerSocketChannel server;
    private Set<ClientConnection> clients = new HashSet<ClientConnection>();

    VNCScreen() {
        super(1024, 600, 32);
        try {
            this.server = ServerSocketChannel.open();
            int n = AccessController.doPrivileged(() -> Integer.getInteger("vnc.port", 5901));
            this.server.bind(new InetSocketAddress(n));
            Thread thread = new Thread(new ConnectionAccepter());
            thread.setDaemon(true);
            thread.setName("VNC Server on port " + n);
            thread.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (ClientConnection clientConnection : this.clients) {
            try {
                clientConnection.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        ClientConnection[] clientConnectionArray = this.clients;
        synchronized (this.clients) {
            ClientConnection[] clientConnectionArray2 = this.clients.toArray(new ClientConnection[this.clients.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ClientConnection clientConnection : clientConnectionArray2) {
                try {
                    this.sendBuffer(clientConnection.socket);
                }
                catch (IOException iOException) {
                    this.clients.remove(clientConnection);
                }
            }
            super.swapBuffers();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(ClientConnection clientConnection, IOException iOException) {
        Set<ClientConnection> set = this.clients;
        synchronized (set) {
            if (this.clients.contains(clientConnection)) {
                System.out.format("Disconnecting %s: %s\n", clientConnection.descriptor, iOException.getMessage());
                this.clients.remove(clientConnection);
            }
        }
    }

    private void sendBuffer(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)this.width);
        byteBuffer.putShort((short)this.height);
        byteBuffer.putInt(0);
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
        this.fb.write(writableByteChannel);
    }

    private class ClientConnection
    implements Runnable {
        private SocketChannel socket;
        private String descriptor;

        private ClientConnection() {
        }

        @Override
        public void run() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(32);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            try {
                this.descriptor = this.socket.getRemoteAddress().toString();
                block11: while (true) {
                    byteBuffer.clear();
                    byteBuffer.limit(4);
                    this.socket.read(byteBuffer);
                    switch (byteBuffer.get(0)) {
                        case 0: {
                            byteBuffer.clear();
                            byteBuffer.limit(16);
                            this.socket.read(byteBuffer);
                            continue block11;
                        }
                        case 1: {
                            byteBuffer.clear();
                            byteBuffer.limit(2);
                            this.socket.read(byteBuffer);
                            short s = byteBuffer.getShort(0);
                            int n2 = 0;
                            while (true) {
                                if (n2 >= s) continue block11;
                                byteBuffer.clear();
                                byteBuffer.limit(6);
                                this.socket.read(byteBuffer);
                                ++n2;
                            }
                        }
                        case 2: {
                            int n;
                            int n2 = byteBuffer.getShort(2);
                            for (n = 0; n < n2; ++n) {
                                byteBuffer.clear();
                                byteBuffer.limit(4);
                                this.socket.read(byteBuffer);
                            }
                        }
                        case 3: {
                            byteBuffer.clear();
                            byteBuffer.limit(6);
                            this.socket.read(byteBuffer);
                            Platform.runLater(() -> {
                                try {
                                    if (!VNCScreen.this.fb.hasReceivedData()) {
                                        VNCScreen.this.sendBuffer(this.socket);
                                    }
                                }
                                catch (IOException iOException) {
                                    VNCScreen.this.removeClient(this, iOException);
                                }
                            });
                            continue block11;
                        }
                        case 4: {
                            byteBuffer.clear();
                            byteBuffer.limit(4);
                            this.socket.read(byteBuffer);
                            continue block11;
                        }
                        case 5: {
                            int n = byteBuffer.getShort(2);
                            byteBuffer.position(1);
                            byteBuffer.limit(2);
                            BitSet bitSet = BitSet.valueOf(byteBuffer);
                            byteBuffer.clear();
                            byteBuffer.limit(2);
                            this.socket.read(byteBuffer);
                            short s = byteBuffer.getShort(0);
                            MouseState mouseState = new MouseState();
                            mouseState.setX(n);
                            mouseState.setY(s);
                            if (bitSet.get(0)) {
                                mouseState.pressButton(212);
                            }
                            if (bitSet.get(1)) {
                                mouseState.pressButton(214);
                            }
                            if (bitSet.get(2)) {
                                mouseState.pressButton(213);
                            }
                            Platform.runLater(() -> MouseInput.getInstance().setState(mouseState, false));
                            continue block11;
                        }
                        case 6: {
                            byteBuffer.clear();
                            byteBuffer.limit(4);
                            this.socket.read(byteBuffer);
                            int n = byteBuffer.getInt(0);
                            int n3 = 0;
                            while (true) {
                                if (n3 >= n) continue block11;
                                byteBuffer.clear();
                                byteBuffer.limit(1);
                                this.socket.read(byteBuffer);
                                ++n3;
                            }
                        }
                    }
                    System.err.format("Unknown message %d from client %s\n", byteBuffer.get(0), this.socket.getRemoteAddress());
                }
            }
            catch (IOException iOException) {
                VNCScreen.this.removeClient(this, iOException);
                return;
            }
        }
    }

    private class ConnectionAccepter
    implements Runnable {
        private ConnectionAccepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(64);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            while (true) {
                try {
                    while (true) {
                        SocketChannel socketChannel = VNCScreen.this.server.accept();
                        System.out.format("Connection received from %s\n", socketChannel.getRemoteAddress());
                        byteBuffer.clear();
                        byteBuffer.put("RFB 003.003\n".getBytes());
                        byteBuffer.flip();
                        socketChannel.write(byteBuffer);
                        byteBuffer.clear();
                        byteBuffer.limit(12);
                        socketChannel.read(byteBuffer);
                        byteBuffer.flip();
                        System.out.format("Client supports %s\n", Charset.forName("UTF-8").decode(byteBuffer).toString().trim());
                        byteBuffer.clear();
                        byteBuffer.putInt(1);
                        byteBuffer.flip();
                        socketChannel.write(byteBuffer);
                        byteBuffer.clear();
                        byteBuffer.limit(1);
                        socketChannel.read(byteBuffer);
                        System.out.format("Client share request: %d\n", byteBuffer.get(0));
                        byteBuffer.clear();
                        byteBuffer.putShort((short)VNCScreen.this.width);
                        byteBuffer.putShort((short)VNCScreen.this.height);
                        byteBuffer.put((byte)VNCScreen.this.depth);
                        byteBuffer.put((byte)VNCScreen.this.depth);
                        byteBuffer.put((byte)(!ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 1 : 0));
                        byteBuffer.put((byte)1);
                        if (VNCScreen.this.depth == 32) {
                            byteBuffer.putShort((short)255);
                            byteBuffer.putShort((short)255);
                            byteBuffer.putShort((short)255);
                            byteBuffer.put((byte)16);
                            byteBuffer.put((byte)8);
                            byteBuffer.put((byte)0);
                        } else {
                            byteBuffer.putShort((short)31);
                            byteBuffer.putShort((short)63);
                            byteBuffer.putShort((short)31);
                            byteBuffer.put((byte)11);
                            byteBuffer.put((byte)5);
                            byteBuffer.put((byte)0);
                        }
                        byteBuffer.put((byte)0);
                        byteBuffer.put((byte)0);
                        byteBuffer.put((byte)0);
                        String string = "JavaFX on " + socketChannel.getLocalAddress();
                        byteBuffer.putInt(string.length());
                        byteBuffer.put(string.getBytes());
                        byteBuffer.flip();
                        socketChannel.write(byteBuffer);
                        ClientConnection clientConnection = new ClientConnection();
                        clientConnection.socket = socketChannel;
                        Thread thread = new Thread(clientConnection);
                        thread.setDaemon(true);
                        thread.setName("VNC client connection from " + socketChannel.getRemoteAddress());
                        thread.start();
                        Set set = VNCScreen.this.clients;
                        synchronized (set) {
                            VNCScreen.this.clients.add(clientConnection);
                        }
                        VNCScreen.this.sendBuffer(socketChannel);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

