/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client;

import com.cdiwit.miseb.frp.client.config.ConfigManager;
import com.cdiwit.miseb.frp.client.ui.MainFrame;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrpClientApplication {
    private static final Logger log = LoggerFactory.getLogger(FrpClientApplication.class);

    public static void main(String[] args) {
        log.info("MISEB FRP\u5ba2\u6237\u7aef\u542f\u52a8...");
        boolean isServiceMode = FrpClientApplication.checkServiceMode(args);
        if (isServiceMode) {
            log.info("\u68c0\u6d4b\u5230\u670d\u52a1\u6a21\u5f0f\u542f\u52a8\u53c2\u6570");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u7cfb\u7edf\u5916\u89c2\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5916\u89c2", e);
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                log.error("\u8bbe\u7f6e\u5916\u89c2\u5931\u8d25", ex);
            }
        }
        FrpClientApplication.setUIFont();
        ConfigManager.getInstance().load();
        boolean shouldAutoConnect = isServiceMode || ConfigManager.getInstance().getClientConfig().isAutoStart();
        SwingUtilities.invokeLater(() -> {
            try {
                MainFrame mainFrame = new MainFrame();
                if (isServiceMode) {
                    mainFrame.setVisible(false);
                    log.info("\u670d\u52a1\u6a21\u5f0f\uff1a\u7a97\u53e3\u5df2\u6700\u5c0f\u5316\u5230\u6258\u76d8");
                } else {
                    mainFrame.setVisible(true);
                }
                if (shouldAutoConnect) {
                    log.info("\u81ea\u52a8\u542f\u52a8\u8fde\u63a5...");
                    mainFrame.autoConnect();
                }
            }
            catch (Exception e) {
                log.error("\u542f\u52a8GUI\u5931\u8d25", e);
                JOptionPane.showMessageDialog(null, "\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage(), "\u9519\u8bef", 0);
                System.exit(1);
            }
        });
    }

    private static void setUIFont() {
        Font defaultFont = new Font("Microsoft YaHei", 0, 12);
        if (!FrpClientApplication.isFontAvailable("Microsoft YaHei")) {
            defaultFont = new Font("SimHei", 0, 12);
            if (!FrpClientApplication.isFontAvailable("SimHei")) {
                defaultFont = new Font("SansSerif", 0, 12);
            }
        }
        FontUIResource fontResource = new FontUIResource(defaultFont);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, fontResource);
        }
    }

    private static boolean isFontAvailable(String fontName) {
        String[] fontNames;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : fontNames = ge.getAvailableFontFamilyNames()) {
            if (!name.equals(fontName)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkServiceMode(String[] args) {
        for (String arg : args) {
            if (!"--service".equalsIgnoreCase(arg) && !"-service".equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }
}

