/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.config;

import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.SecureUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class ClientConfig {
    private String serverHost = "127.0.0.1";
    private int serverPort = 7000;
    private String authCode;
    private String clientId = this.generateClientId();
    private boolean autoStart = false;
    private boolean minimizeToTray = true;

    private String generateClientId() {
        try {
            byte[] mac;
            StringBuilder sb = new StringBuilder();
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
            }
            sb.append(System.getProperty("user.name"));
            sb.append(System.getProperty("os.name"));
            return SecureUtil.md5(sb.toString()).substring(0, 16).toUpperCase();
        }
        catch (Exception e) {
            return IdUtil.simpleUUID().substring(0, 16).toUpperCase();
        }
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isMinimizeToTray() {
        return this.minimizeToTray;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setMinimizeToTray(boolean minimizeToTray) {
        this.minimizeToTray = minimizeToTray;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getServerPort() != other.getServerPort()) {
            return false;
        }
        if (this.isAutoStart() != other.isAutoStart()) {
            return false;
        }
        if (this.isMinimizeToTray() != other.isMinimizeToTray()) {
            return false;
        }
        String this$serverHost = this.getServerHost();
        String other$serverHost = other.getServerHost();
        if (this$serverHost == null ? other$serverHost != null : !this$serverHost.equals(other$serverHost)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getServerPort();
        result = result * 59 + (this.isAutoStart() ? 79 : 97);
        result = result * 59 + (this.isMinimizeToTray() ? 79 : 97);
        String $serverHost = this.getServerHost();
        result = result * 59 + ($serverHost == null ? 43 : $serverHost.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfig(serverHost=" + this.getServerHost() + ", serverPort=" + this.getServerPort() + ", authCode=" + this.getAuthCode() + ", clientId=" + this.getClientId() + ", autoStart=" + this.isAutoStart() + ", minimizeToTray=" + this.isMinimizeToTray() + ")";
    }
}

