/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cdiwit.miseb.frp.client.config.ClientConfig;
import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static final String CONFIG_FILE = "frp-client.json";
    private final String configPath;
    private ClientConfig clientConfig;
    private List<ProxyConfig> proxyConfigs;
    private static ConfigManager instance;

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    private ConfigManager() {
        String userDir = System.getProperty("user.dir");
        this.configPath = userDir + File.separator + CONFIG_FILE;
        this.clientConfig = new ClientConfig();
        this.proxyConfigs = new ArrayList<ProxyConfig>();
    }

    public void load() {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            log.info("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e");
            ProxyConfig defaultProxy = new ProxyConfig("erp", 8080);
            defaultProxy.setRemark("ERP\u7cfb\u7edf");
            this.proxyConfigs.add(defaultProxy);
            return;
        }
        try {
            List<ProxyConfig> loadedProxies;
            ClientConfig loadedConfig;
            String content = FileUtil.readString(configFile, StandardCharsets.UTF_8);
            JSONObject json = JSON.parseObject(content);
            if (json.containsKey("client") && (loadedConfig = json.getObject("client", ClientConfig.class)) != null) {
                String clientId = this.clientConfig.getClientId();
                this.clientConfig = loadedConfig;
                if (StrUtil.isBlank(this.clientConfig.getClientId())) {
                    this.clientConfig.setClientId(clientId);
                }
            }
            if (json.containsKey("proxies") && (loadedProxies = json.getJSONArray("proxies").toJavaList(ProxyConfig.class)) != null && !loadedProxies.isEmpty()) {
                this.proxyConfigs = loadedProxies;
            }
            log.info("\u914d\u7f6e\u52a0\u8f7d\u6210\u529f: {}", (Object)this.configPath);
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u5931\u8d25", e);
        }
    }

    public void save() {
        try {
            JSONObject json = new JSONObject();
            json.put("client", (Object)this.clientConfig);
            json.put("proxies", (Object)this.proxyConfigs);
            String content = JSON.toJSONString((Object)json, SerializerFeature.PrettyFormat);
            FileUtil.writeString(content, this.configPath, StandardCharsets.UTF_8);
            log.info("\u914d\u7f6e\u4fdd\u5b58\u6210\u529f: {}", (Object)this.configPath);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25", e);
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public List<ProxyConfig> getProxyConfigs() {
        return this.proxyConfigs;
    }

    public void addProxyConfig(ProxyConfig config) {
        this.proxyConfigs.add(config);
    }

    public void removeProxyConfig(ProxyConfig config) {
        this.proxyConfigs.remove(config);
    }

    public void clearProxyConfigs() {
        this.proxyConfigs.clear();
    }
}

