/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.netty;

import com.alibaba.fastjson.JSON;
import com.cdiwit.miseb.frp.client.config.ClientConfig;
import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import com.cdiwit.miseb.frp.client.netty.ConnectionListener;
import com.cdiwit.miseb.frp.client.netty.codec.MessageDecoder;
import com.cdiwit.miseb.frp.client.netty.codec.MessageEncoder;
import com.cdiwit.miseb.frp.client.protocol.DataChannelReady;
import com.cdiwit.miseb.frp.client.protocol.DataTransfer;
import com.cdiwit.miseb.frp.client.protocol.MessageType;
import com.cdiwit.miseb.frp.client.protocol.ProxyMessage;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChannelClient {
    private static final Logger log = LoggerFactory.getLogger(DataChannelClient.class);
    private final ClientConfig clientConfig;
    private final String connectionId;
    private final ProxyConfig proxyConfig;
    private final ConnectionListener listener;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;
    private Channel localChannel;
    private final AtomicLong inBytes = new AtomicLong(0L);
    private final AtomicLong outBytes = new AtomicLong(0L);

    public DataChannelClient(ClientConfig clientConfig, String connectionId, ProxyConfig proxyConfig, ConnectionListener listener) {
        this.clientConfig = clientConfig;
        this.connectionId = connectionId;
        this.proxyConfig = proxyConfig;
        this.listener = listener;
    }

    public void connect() {
        this.workerGroup = new NioEventLoopGroup(2);
        this.connectToServer();
    }

    private void connectToServer() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new MessageDecoder());
                pipeline.addLast(new MessageEncoder());
                pipeline.addLast(new ServerDataHandler());
            }
        });
        bootstrap.connect(this.clientConfig.getServerHost(), this.clientConfig.getServerPort()).addListener(future -> {
            if (future.isSuccess()) {
                this.serverChannel = future.channel();
                log.debug("\u6570\u636e\u901a\u9053\u8fde\u63a5\u670d\u52a1\u7aef\u6210\u529f: connectionId={}", (Object)this.connectionId);
                DataChannelReady ready = new DataChannelReady(this.connectionId, null, this.proxyConfig.getProxyName());
                this.serverChannel.writeAndFlush(ProxyMessage.dataChannelReady(JSON.toJSONString(ready)));
                this.connectToLocal();
            } else {
                log.error("\u6570\u636e\u901a\u9053\u8fde\u63a5\u670d\u52a1\u7aef\u5931\u8d25: connectionId={}", (Object)this.connectionId, (Object)future.cause());
                this.shutdown();
            }
        });
    }

    private void connectToLocal() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new LocalDataHandler());
            }
        });
        bootstrap.connect(this.proxyConfig.getLocalIp(), this.proxyConfig.getLocalPort()).addListener(future -> {
            if (future.isSuccess()) {
                this.localChannel = future.channel();
                log.debug("\u8fde\u63a5\u672c\u5730\u670d\u52a1\u6210\u529f: {}:{}", (Object)this.proxyConfig.getLocalIp(), (Object)this.proxyConfig.getLocalPort());
            } else {
                log.error("\u8fde\u63a5\u672c\u5730\u670d\u52a1\u5931\u8d25: {}:{}", this.proxyConfig.getLocalIp(), this.proxyConfig.getLocalPort(), future.cause());
                if (this.serverChannel != null && this.serverChannel.isActive()) {
                    String closeData = "{\"connectionId\":\"" + this.connectionId + "\"}";
                    this.serverChannel.writeAndFlush(ProxyMessage.of(MessageType.CONNECTION_CLOSE, closeData));
                }
                this.shutdown();
            }
        });
    }

    public void shutdown() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.localChannel != null) {
            this.localChannel.close();
        }
        if (this.workerGroup != null && !this.workerGroup.isShutdown()) {
            try {
                this.workerGroup.shutdownGracefully(0L, 2L, TimeUnit.SECONDS).sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class LocalDataHandler
    extends ChannelInboundHandlerAdapter {
        private LocalDataHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ByteBuf buf = (ByteBuf)msg;
            try {
                byte[] data = new byte[buf.readableBytes()];
                buf.readBytes(data);
                if (DataChannelClient.this.serverChannel != null && DataChannelClient.this.serverChannel.isActive()) {
                    DataTransfer transfer = new DataTransfer(DataChannelClient.this.connectionId, data);
                    DataChannelClient.this.serverChannel.writeAndFlush(ProxyMessage.dataTransfer(JSON.toJSONString(transfer)));
                    DataChannelClient.this.outBytes.addAndGet(data.length);
                    DataChannelClient.this.listener.onTrafficUpdate(0L, data.length);
                    log.debug("\u8f6c\u53d1\u6570\u636e\u5230\u670d\u52a1\u7aef: {} bytes", (Object)data.length);
                }
            }
            finally {
                buf.release();
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            log.debug("\u672c\u5730\u670d\u52a1\u8fde\u63a5\u65ad\u5f00: connectionId={}", (Object)DataChannelClient.this.connectionId);
            if (DataChannelClient.this.serverChannel != null && DataChannelClient.this.serverChannel.isActive()) {
                String closeData = "{\"connectionId\":\"" + DataChannelClient.this.connectionId + "\"}";
                DataChannelClient.this.serverChannel.writeAndFlush(ProxyMessage.of(MessageType.CONNECTION_CLOSE, closeData));
            }
            DataChannelClient.this.shutdown();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("\u672c\u5730\u670d\u52a1\u8fde\u63a5\u5f02\u5e38", cause);
            DataChannelClient.this.shutdown();
        }
    }

    private class ServerDataHandler
    extends SimpleChannelInboundHandler<ProxyMessage> {
        private ServerDataHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, ProxyMessage msg) {
            if (msg.getType() == MessageType.DATA_TRANSFER) {
                DataTransfer transfer = JSON.parseObject(msg.getData(), DataTransfer.class);
                byte[] data = transfer.getDecodedData();
                if (DataChannelClient.this.localChannel != null && DataChannelClient.this.localChannel.isActive()) {
                    DataChannelClient.this.localChannel.writeAndFlush(Unpooled.wrappedBuffer(data));
                    DataChannelClient.this.inBytes.addAndGet(data.length);
                    DataChannelClient.this.listener.onTrafficUpdate(data.length, 0L);
                    log.debug("\u8f6c\u53d1\u6570\u636e\u5230\u672c\u5730\u670d\u52a1: {} bytes", (Object)data.length);
                }
            } else if (msg.getType() == MessageType.CONNECTION_CLOSE) {
                log.debug("\u6536\u5230\u8fde\u63a5\u5173\u95ed\u6d88\u606f");
                DataChannelClient.this.shutdown();
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            log.debug("\u670d\u52a1\u7aef\u6570\u636e\u901a\u9053\u65ad\u5f00: connectionId={}", (Object)DataChannelClient.this.connectionId);
            DataChannelClient.this.shutdown();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("\u670d\u52a1\u7aef\u6570\u636e\u901a\u9053\u5f02\u5e38", cause);
            DataChannelClient.this.shutdown();
        }
    }
}

