/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.netty;

import com.cdiwit.miseb.frp.client.config.ClientConfig;
import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import com.cdiwit.miseb.frp.client.netty.ConnectionListener;
import com.cdiwit.miseb.frp.client.netty.codec.MessageDecoder;
import com.cdiwit.miseb.frp.client.netty.codec.MessageEncoder;
import com.cdiwit.miseb.frp.client.netty.handler.TunnelClientHandler;
import com.cdiwit.miseb.frp.client.protocol.FrpCrypto;
import com.cdiwit.miseb.frp.client.protocol.ProxyMessage;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClient {
    private static final Logger log = LoggerFactory.getLogger(TunnelClient.class);
    public static final AttributeKey<byte[]> ENCRYPTION_KEY = AttributeKey.valueOf("encryptionKey");
    public static final AttributeKey<String> AUTH_CODE = AttributeKey.valueOf("authCode");
    private final ClientConfig clientConfig;
    private final List<ProxyConfig> proxyConfigs;
    private final ConnectionListener listener;
    private EventLoopGroup workerGroup;
    private Channel controlChannel;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean shouldReconnect = new AtomicBoolean(true);
    private final AtomicBoolean isReconnecting = new AtomicBoolean(false);
    private final AtomicInteger reconnectTimes = new AtomicInteger(0);
    private volatile Thread reconnectThread;
    private String sessionId;
    private static final int[] RECONNECT_INTERVALS = new int[]{5, 10, 30, 60, 300};

    public TunnelClient(ClientConfig clientConfig, List<ProxyConfig> proxyConfigs, ConnectionListener listener) {
        this.clientConfig = clientConfig;
        this.proxyConfigs = proxyConfigs;
        this.listener = listener;
    }

    public void connect() {
        if (this.connected.get()) {
            log.warn("\u5df2\u7ecf\u8fde\u63a5\u5230\u670d\u52a1\u7aef");
            return;
        }
        this.shouldReconnect.set(true);
        this.doConnect();
    }

    private void doConnect() {
        block2: {
            this.workerGroup = new NioEventLoopGroup();
            try {
                Bootstrap bootstrap = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 10000)).handler(new ChannelInitializer<SocketChannel>(){

                    @Override
                    protected void initChannel(SocketChannel ch) {
                        String authCode = TunnelClient.this.clientConfig.getAuthCode();
                        if (authCode != null && !authCode.isEmpty()) {
                            byte[] key = FrpCrypto.deriveKey(authCode);
                            ch.attr(ENCRYPTION_KEY).set(key);
                            ch.attr(AUTH_CODE).set(authCode);
                        }
                        ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addLast(new IdleStateHandler(0L, 30L, 0L, TimeUnit.SECONDS));
                        pipeline.addLast(new MessageDecoder());
                        pipeline.addLast(new MessageEncoder());
                        pipeline.addLast(new TunnelClientHandler(TunnelClient.this, TunnelClient.this.clientConfig, TunnelClient.this.proxyConfigs, TunnelClient.this.listener));
                    }
                });
                String host = this.clientConfig.getServerHost();
                int port = this.clientConfig.getServerPort();
                this.listener.onLog("\u6b63\u5728\u8fde\u63a5\u670d\u52a1\u7aef " + host + ":" + port + " ...");
                ChannelFuture future = bootstrap.connect(host, port);
                future.addListener(f -> {
                    if (f.isSuccess()) {
                        this.controlChannel = f.channel();
                        this.connected.set(true);
                        this.reconnectTimes.set(0);
                        this.listener.onLog("\u8fde\u63a5\u6210\u529f\uff0c\u6b63\u5728\u8ba4\u8bc1...");
                        this.controlChannel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> {
                            this.connected.set(false);
                            this.sessionId = null;
                            this.listener.onDisconnected();
                            this.listener.onLog("\u8fde\u63a5\u5df2\u65ad\u5f00");
                            if (this.shouldReconnect.get()) {
                                this.scheduleReconnect();
                            }
                        }));
                    } else {
                        this.listener.onLog("\u8fde\u63a5\u5931\u8d25: " + f.cause().getMessage());
                        this.listener.onConnectFailed(f.cause().getMessage());
                        this.shutdown();
                        if (this.shouldReconnect.get()) {
                            this.scheduleReconnect();
                        }
                    }
                });
            }
            catch (Exception e) {
                log.error("\u8fde\u63a5\u670d\u52a1\u7aef\u5f02\u5e38", e);
                this.listener.onLog("\u8fde\u63a5\u5f02\u5e38: " + e.getMessage());
                this.listener.onConnectFailed(e.getMessage());
                this.shutdown();
                if (!this.shouldReconnect.get()) break block2;
                this.scheduleReconnect();
            }
        }
    }

    private void scheduleReconnect() {
        int maxTimes = -1;
        int times = this.reconnectTimes.incrementAndGet();
        if (maxTimes > 0 && times > maxTimes) {
            this.listener.onLog("\u91cd\u8fde\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u505c\u6b62\u91cd\u8fde");
            this.isReconnecting.set(false);
            return;
        }
        int intervalIndex = Math.min(times - 1, RECONNECT_INTERVALS.length - 1);
        int interval = RECONNECT_INTERVALS[intervalIndex];
        String intervalText = interval >= 60 ? interval / 60 + "\u5206\u949f" : interval + "\u79d2";
        this.listener.onLog(String.format("\u5c06\u5728 %s \u540e\u8fdb\u884c\u7b2c %d \u6b21\u91cd\u8fde...", intervalText, times));
        this.isReconnecting.set(true);
        this.reconnectThread = new Thread(() -> {
            try {
                for (int remaining = interval; remaining > 0; --remaining) {
                    if (!this.shouldReconnect.get()) {
                        this.isReconnecting.set(false);
                        this.listener.onLog("\u91cd\u8fde\u5df2\u53d6\u6d88");
                        return;
                    }
                    this.listener.onReconnecting(times, remaining);
                    Thread.sleep(1000L);
                }
                if (this.shouldReconnect.get() && !this.connected.get()) {
                    this.isReconnecting.set(false);
                    this.doConnect();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.isReconnecting.set(false);
            }
        });
        this.reconnectThread.setName("FRP-Reconnect-" + times);
        this.reconnectThread.start();
    }

    public void disconnect() {
        this.shouldReconnect.set(false);
        this.isReconnecting.set(false);
        if (this.reconnectThread != null && this.reconnectThread.isAlive()) {
            this.reconnectThread.interrupt();
        }
        if (this.controlChannel != null && this.controlChannel.isActive()) {
            this.controlChannel.writeAndFlush(ProxyMessage.disconnect());
            this.controlChannel.close();
        }
        this.shutdown();
    }

    public void cancelConnect() {
        this.shouldReconnect.set(false);
        this.isReconnecting.set(false);
        if (this.reconnectThread != null && this.reconnectThread.isAlive()) {
            this.reconnectThread.interrupt();
        }
        this.shutdown();
        this.listener.onLog("\u8fde\u63a5\u5df2\u53d6\u6d88");
        this.listener.onDisconnected();
    }

    public boolean isReconnecting() {
        return this.isReconnecting.get();
    }

    private void shutdown() {
        if (this.workerGroup != null && !this.workerGroup.isShutdown()) {
            try {
                this.workerGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS).sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.connected.set(false);
        this.sessionId = null;
    }

    public void sendMessage(ProxyMessage message) {
        if (this.controlChannel != null && this.controlChannel.isActive()) {
            this.controlChannel.writeAndFlush(message);
        }
    }

    public boolean isConnected() {
        return this.connected.get() && this.controlChannel != null && this.controlChannel.isActive();
    }

    public boolean isAuthenticated() {
        return this.sessionId != null;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public List<ProxyConfig> getProxyConfigs() {
        return this.proxyConfigs;
    }
}

