/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.netty.codec;

import com.cdiwit.miseb.frp.client.netty.TunnelClient;
import com.cdiwit.miseb.frp.client.protocol.FrpCrypto;
import com.cdiwit.miseb.frp.client.protocol.MessageType;
import com.cdiwit.miseb.frp.client.protocol.ProxyMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MessageDecoder.class);
    private static final int HEADER_LENGTH = 8;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 8) {
            return;
        }
        in.markReaderIndex();
        short magic = in.readShort();
        if (magic != 19782) {
            log.error("\u65e0\u6548\u7684\u534f\u8bae\u9b54\u6570: 0x{}", (Object)Integer.toHexString(magic & 0xFFFF));
            ctx.close();
            return;
        }
        byte version = in.readByte();
        if (version != 1 && version != 2) {
            log.error("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c: 0x{}", (Object)Integer.toHexString(version & 0xFF));
            ctx.close();
            return;
        }
        int typeCode = in.readByte() & 0xFF;
        MessageType type = MessageType.fromCode(typeCode);
        if (type == null) {
            log.error("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b: 0x{}", (Object)Integer.toHexString(typeCode));
            ctx.close();
            return;
        }
        int length = in.readInt();
        if (length < 0 || length > 0x100000) {
            log.error("\u65e0\u6548\u7684\u6570\u636e\u957f\u5ea6: {}", (Object)length);
            ctx.close();
            return;
        }
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        String data = "";
        if (length > 0) {
            byte[] dataBytes = new byte[length];
            in.readBytes(dataBytes);
            if (version == 2) {
                data = this.decryptData(ctx, dataBytes);
                if (data == null) {
                    return;
                }
            } else {
                data = new String(dataBytes, StandardCharsets.UTF_8);
            }
        }
        ProxyMessage message = new ProxyMessage();
        message.setMagic(magic);
        message.setVersion(version);
        message.setType(type);
        message.setData(data);
        out.add(message);
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u7801\u6d88\u606f: type={}, version=0x{}, dataLength={}", new Object[]{type, Integer.toHexString(version & 0xFF), length});
        }
    }

    private String decryptData(ChannelHandlerContext ctx, byte[] encryptedData) {
        try {
            byte[] key = ctx.channel().attr(TunnelClient.ENCRYPTION_KEY).get();
            if (key == null) {
                log.error("\u65e0\u6cd5\u89e3\u5bc6\u54cd\u5e94\uff0c\u7f3a\u5c11\u52a0\u5bc6\u5bc6\u94a5");
                ctx.close();
                return null;
            }
            return FrpCrypto.decryptToString(encryptedData, key);
        }
        catch (SecurityException e) {
            log.error("\u89e3\u5bc6\u5931\u8d25\uff08\u6570\u636e\u53ef\u80fd\u88ab\u7be1\u6539\uff09: {}", (Object)e.getMessage());
            ctx.close();
            return null;
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5f02\u5e38: {}", (Object)e.getMessage());
            ctx.close();
            return null;
        }
    }
}

