/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.netty.codec;

import com.cdiwit.miseb.frp.client.netty.TunnelClient;
import com.cdiwit.miseb.frp.client.protocol.FrpCrypto;
import com.cdiwit.miseb.frp.client.protocol.MessageType;
import com.cdiwit.miseb.frp.client.protocol.ProxyMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEncoder
extends MessageToByteEncoder<ProxyMessage> {
    private static final Logger log = LoggerFactory.getLogger(MessageEncoder.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, ProxyMessage msg, ByteBuf out) throws Exception {
        byte[] dataBytes;
        int version;
        byte[] key = ctx.channel().attr(TunnelClient.ENCRYPTION_KEY).get();
        boolean useEncryption = key != null;
        int n = version = useEncryption ? 2 : 1;
        if (msg.getData() != null && !msg.getData().isEmpty()) {
            byte[] plainBytes = msg.getData().getBytes(StandardCharsets.UTF_8);
            dataBytes = useEncryption ? (msg.getType() == MessageType.AUTH_REQUEST ? this.encryptAuthRequest(ctx, plainBytes, key) : FrpCrypto.encrypt(plainBytes, key)) : plainBytes;
        } else {
            dataBytes = new byte[]{};
        }
        out.writeShort(19782);
        out.writeByte(version);
        out.writeByte(msg.getType().getCode());
        out.writeInt(dataBytes.length);
        if (dataBytes.length > 0) {
            out.writeBytes(dataBytes);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7f16\u7801\u6d88\u606f: type={}, version=0x{}, dataLength={}", new Object[]{msg.getType(), Integer.toHexString(version & 0xFF), dataBytes.length});
        }
    }

    private byte[] encryptAuthRequest(ChannelHandlerContext ctx, byte[] plainData, byte[] key) {
        String authCode = ctx.channel().attr(TunnelClient.AUTH_CODE).get();
        if (authCode == null || authCode.isEmpty()) {
            log.warn("AUTH_REQUEST\u7f3a\u5c11authCode\uff0c\u4f7f\u7528\u660e\u6587\u4f20\u8f93");
            return plainData;
        }
        byte[] authCodeBytes = authCode.getBytes(StandardCharsets.UTF_8);
        byte[] encryptedData = FrpCrypto.encrypt(plainData, key);
        ByteBuffer buffer = ByteBuffer.allocate(4 + authCodeBytes.length + encryptedData.length);
        buffer.putInt(authCodeBytes.length);
        buffer.put(authCodeBytes);
        buffer.put(encryptedData);
        return buffer.array();
    }
}

