/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.netty.handler;

import com.alibaba.fastjson.JSON;
import com.cdiwit.miseb.frp.client.config.ClientConfig;
import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import com.cdiwit.miseb.frp.client.netty.ConnectionListener;
import com.cdiwit.miseb.frp.client.netty.DataChannelClient;
import com.cdiwit.miseb.frp.client.netty.TunnelClient;
import com.cdiwit.miseb.frp.client.protocol.AuthRequest;
import com.cdiwit.miseb.frp.client.protocol.AuthResponse;
import com.cdiwit.miseb.frp.client.protocol.DataTransfer;
import com.cdiwit.miseb.frp.client.protocol.NewConnection;
import com.cdiwit.miseb.frp.client.protocol.ProxyMessage;
import com.cdiwit.miseb.frp.client.protocol.ProxyRegister;
import com.cdiwit.miseb.frp.client.protocol.ProxyRegisterAck;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClientHandler
extends SimpleChannelInboundHandler<ProxyMessage> {
    private static final Logger log = LoggerFactory.getLogger(TunnelClientHandler.class);
    private final TunnelClient tunnelClient;
    private final ClientConfig clientConfig;
    private final List<ProxyConfig> proxyConfigs;
    private final ConnectionListener listener;
    private final Map<String, ProxyConfig> proxyConfigMap = new HashMap<String, ProxyConfig>();
    private final Queue<String> pendingProxies = new LinkedList<String>();

    public TunnelClientHandler(TunnelClient tunnelClient, ClientConfig clientConfig, List<ProxyConfig> proxyConfigs, ConnectionListener listener) {
        this.tunnelClient = tunnelClient;
        this.clientConfig = clientConfig;
        this.proxyConfigs = proxyConfigs;
        this.listener = listener;
        for (ProxyConfig config : proxyConfigs) {
            this.proxyConfigMap.put(config.getProxyName(), config);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        AuthRequest authRequest = new AuthRequest();
        authRequest.setAuthCode(this.clientConfig.getAuthCode());
        authRequest.setClientId(this.clientConfig.getClientId());
        authRequest.setClientVersion("1.0.0");
        authRequest.setOsType(System.getProperty("os.name"));
        authRequest.setTimestamp(System.currentTimeMillis());
        ctx.writeAndFlush(ProxyMessage.authRequest(JSON.toJSONString(authRequest)));
        this.listener.onLog("\u5df2\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42");
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ProxyMessage msg) {
        switch (msg.getType()) {
            case AUTH_RESPONSE: {
                this.handleAuthResponse(ctx, msg);
                break;
            }
            case HEARTBEAT_ACK: {
                log.debug("\u6536\u5230\u5fc3\u8df3\u786e\u8ba4");
                break;
            }
            case PROXY_REGISTER_ACK: {
                this.handleProxyRegisterAck(ctx, msg);
                break;
            }
            case NEW_CONNECTION: {
                this.handleNewConnection(ctx, msg);
                break;
            }
            case CONNECTION_CLOSE: {
                this.handleConnectionClose(ctx, msg);
                break;
            }
            case DATA_TRANSFER: {
                this.handleDataTransfer(ctx, msg);
                break;
            }
            case TRAFFIC_REPORT: {
                log.debug("\u6536\u5230\u6d41\u91cf\u7edf\u8ba1\u786e\u8ba4");
                break;
            }
            case CONFIG_UPDATE: {
                this.handleConfigUpdate(ctx, msg);
                break;
            }
            case ERROR: {
                this.handleError(ctx, msg);
                break;
            }
            default: {
                log.warn("\u672a\u77e5\u6d88\u606f\u7c7b\u578b: {}", (Object)msg.getType());
            }
        }
    }

    private void handleAuthResponse(ChannelHandlerContext ctx, ProxyMessage msg) {
        AuthResponse response = JSON.parseObject(msg.getData(), AuthResponse.class);
        if (response.isSuccess()) {
            this.tunnelClient.setSessionId(response.getSessionId());
            this.listener.onLog("\u8ba4\u8bc1\u6210\u529f\uff0c\u4f1a\u8bddID: " + response.getSessionId());
            this.listener.onAuthenticated(response.getSessionId(), response.getAllocatedPorts());
            this.listener.onConnected();
            this.registerProxies(ctx, response.getAllocatedPorts());
        } else {
            this.listener.onLog("\u8ba4\u8bc1\u5931\u8d25: " + response.getMessage());
            this.listener.onAuthFailed(response.getMessage());
            ctx.close();
        }
    }

    private void registerProxies(ChannelHandlerContext ctx, List<Integer> allocatedPorts) {
        this.pendingProxies.clear();
        int portIndex = 0;
        for (ProxyConfig config : this.proxyConfigs) {
            if (!config.isEnabled()) continue;
            ProxyRegister register = new ProxyRegister();
            register.setProxyName(config.getProxyName());
            register.setProxyType(config.getProxyType());
            register.setLocalIp(config.getLocalIp());
            register.setLocalPort(config.getLocalPort());
            if (config.getRemotePort() > 0) {
                register.setRemotePort(config.getRemotePort());
            } else if (allocatedPorts != null && portIndex < allocatedPorts.size()) {
                register.setRemotePort(allocatedPorts.get(portIndex++));
            }
            this.pendingProxies.offer(config.getProxyName());
            ctx.writeAndFlush(ProxyMessage.proxyRegister(JSON.toJSONString(register)));
            this.listener.onLog("\u6b63\u5728\u6ce8\u518c\u4ee3\u7406: " + config.getProxyName() + " -> " + config.getLocalIp() + ":" + config.getLocalPort());
        }
    }

    private void handleProxyRegisterAck(ChannelHandlerContext ctx, ProxyMessage msg) {
        ProxyRegisterAck ack = JSON.parseObject(msg.getData(), ProxyRegisterAck.class);
        String proxyName = ack.getProxyName();
        if (proxyName == null || proxyName.isEmpty()) {
            proxyName = this.pendingProxies.poll();
        } else {
            this.pendingProxies.remove(proxyName);
        }
        if (proxyName == null) {
            proxyName = "\u672a\u77e5\u4ee3\u7406";
        }
        if (ack.isSuccess()) {
            this.listener.onLog(String.format("\u4ee3\u7406\u6ce8\u518c\u6210\u529f: %s -> \u8fdc\u7a0b\u7aef\u53e3 %d", proxyName, ack.getRemotePort()));
            this.listener.onProxyRegistered(proxyName, ack.getRemotePort());
            ProxyConfig config = this.proxyConfigMap.get(proxyName);
            if (config != null) {
                config.setRemotePort(ack.getRemotePort());
            }
        } else {
            this.listener.onLog("\u4ee3\u7406\u6ce8\u518c\u5931\u8d25: " + proxyName + " - " + ack.getMessage());
            this.listener.onProxyRegisterFailed(proxyName, ack.getMessage());
            this.listener.onLog("\u7531\u4e8e\u4ee3\u7406\u6ce8\u518c\u5931\u8d25\uff0c\u65ad\u5f00\u8fde\u63a5");
            ctx.close();
        }
    }

    private void handleNewConnection(ChannelHandlerContext ctx, ProxyMessage msg) {
        NewConnection newConn = JSON.parseObject(msg.getData(), NewConnection.class);
        log.info("\u6536\u5230\u65b0\u8fde\u63a5\u901a\u77e5: connectionId={}, proxyName={}, remoteAddr={}", newConn.getConnectionId(), newConn.getProxyName(), newConn.getRemoteAddr());
        this.listener.onLog("\u65b0\u8fde\u63a5: " + newConn.getRemoteAddr() + " -> " + newConn.getProxyName());
        ProxyConfig proxyConfig = this.proxyConfigMap.get(newConn.getProxyName());
        if (proxyConfig == null) {
            log.warn("\u672a\u627e\u5230\u4ee3\u7406\u914d\u7f6e: {}", (Object)newConn.getProxyName());
            return;
        }
        DataChannelClient dataChannel = new DataChannelClient(this.clientConfig, newConn.getConnectionId(), proxyConfig, this.listener);
        dataChannel.connect();
    }

    private void handleConnectionClose(ChannelHandlerContext ctx, ProxyMessage msg) {
        String connectionId = JSON.parseObject(msg.getData()).getString("connectionId");
        log.debug("\u8fde\u63a5\u5173\u95ed\u901a\u77e5: connectionId={}", (Object)connectionId);
    }

    private void handleDataTransfer(ChannelHandlerContext ctx, ProxyMessage msg) {
        DataTransfer transfer = JSON.parseObject(msg.getData(), DataTransfer.class);
        log.debug("\u6536\u5230\u6570\u636e\u4f20\u8f93\uff08\u901a\u8fc7\u63a7\u5236\u901a\u9053\uff09: connectionId={}", (Object)transfer.getConnectionId());
    }

    private void handleConfigUpdate(ChannelHandlerContext ctx, ProxyMessage msg) {
        log.info("\u6536\u5230\u914d\u7f6e\u66f4\u65b0\u901a\u77e5");
        this.listener.onLog("\u6536\u5230\u670d\u52a1\u7aef\u914d\u7f6e\u66f4\u65b0\u901a\u77e5");
    }

    private void handleError(ChannelHandlerContext ctx, ProxyMessage msg) {
        String errorMessage = msg.getData();
        log.error("\u6536\u5230\u670d\u52a1\u7aef\u9519\u8bef\u6d88\u606f: {}", (Object)errorMessage);
        this.listener.onLog("\u670d\u52a1\u7aef\u9519\u8bef: " + errorMessage);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.writeAndFlush(ProxyMessage.heartbeat());
            log.debug("\u53d1\u9001\u5fc3\u8df3");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        log.info("\u4e0e\u670d\u52a1\u7aef\u7684\u8fde\u63a5\u65ad\u5f00");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("\u901a\u9053\u5f02\u5e38", cause);
        this.listener.onLog("\u8fde\u63a5\u5f02\u5e38: " + cause.getMessage());
        ctx.close();
    }
}

