/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FrpCrypto {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int GCM_TAG_LENGTH = 128;
    private static final int GCM_IV_LENGTH = 12;
    private static final int KEY_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static byte[] deriveKey(String authCode) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(authCode.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bc6\u94a5\u6d3e\u751f\u5931\u8d25", e);
        }
    }

    public static byte[] encrypt(byte[] plaintext, byte[] key) {
        try {
            byte[] iv = new byte[12];
            SECURE_RANDOM.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
            cipher.init(1, (Key)secretKey, spec);
            byte[] ciphertext = cipher.doFinal(plaintext);
            ByteBuffer buffer = ByteBuffer.allocate(12 + ciphertext.length);
            buffer.put(iv);
            buffer.put(ciphertext);
            return buffer.array();
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static byte[] encrypt(String plaintext, byte[] key) {
        return FrpCrypto.encrypt(plaintext.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] decrypt(byte[] encrypted, byte[] key) {
        try {
            if (encrypted.length < 28) {
                throw new SecurityException("\u52a0\u5bc6\u6570\u636e\u957f\u5ea6\u4e0d\u8db3");
            }
            byte[] iv = new byte[12];
            System.arraycopy(encrypted, 0, iv, 0, 12);
            byte[] ciphertext = new byte[encrypted.length - 12];
            System.arraycopy(encrypted, 12, ciphertext, 0, ciphertext.length);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
            cipher.init(2, (Key)secretKey, spec);
            return cipher.doFinal(ciphertext);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException("\u89e3\u5bc6\u5931\u8d25\u6216\u6570\u636e\u88ab\u7be1\u6539", e);
        }
    }

    public static String decryptToString(byte[] encrypted, byte[] key) {
        byte[] plaintext = FrpCrypto.decrypt(encrypted, key);
        return new String(plaintext, StandardCharsets.UTF_8);
    }

    public static boolean isValidKey(byte[] key) {
        return key != null && key.length == 32;
    }
}

