/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.protocol;

import com.cdiwit.miseb.frp.client.protocol.MessageType;

public class ProxyMessage {
    private short magic = (short)19782;
    private byte version = 1;
    private MessageType type;
    private String data;

    public ProxyMessage() {
    }

    public ProxyMessage(MessageType type, String data) {
        this.type = type;
        this.data = data;
    }

    public static ProxyMessage of(MessageType type, String data) {
        return new ProxyMessage(type, data);
    }

    public static ProxyMessage authRequest(String data) {
        return new ProxyMessage(MessageType.AUTH_REQUEST, data);
    }

    public static ProxyMessage authResponse(String data) {
        return new ProxyMessage(MessageType.AUTH_RESPONSE, data);
    }

    public static ProxyMessage heartbeat() {
        return new ProxyMessage(MessageType.HEARTBEAT, "{}");
    }

    public static ProxyMessage heartbeatAck() {
        return new ProxyMessage(MessageType.HEARTBEAT_ACK, "{}");
    }

    public static ProxyMessage proxyRegister(String data) {
        return new ProxyMessage(MessageType.PROXY_REGISTER, data);
    }

    public static ProxyMessage proxyRegisterAck(String data) {
        return new ProxyMessage(MessageType.PROXY_REGISTER_ACK, data);
    }

    public static ProxyMessage newConnection(String data) {
        return new ProxyMessage(MessageType.NEW_CONNECTION, data);
    }

    public static ProxyMessage dataChannelReady(String data) {
        return new ProxyMessage(MessageType.DATA_CHANNEL_READY, data);
    }

    public static ProxyMessage dataTransfer(String data) {
        return new ProxyMessage(MessageType.DATA_TRANSFER, data);
    }

    public static ProxyMessage disconnect() {
        return new ProxyMessage(MessageType.DISCONNECT, "{}");
    }

    public static ProxyMessage connectionClose(String data) {
        return new ProxyMessage(MessageType.CONNECTION_CLOSE, data);
    }

    public short getMagic() {
        return this.magic;
    }

    public byte getVersion() {
        return this.version;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public void setMagic(short magic) {
        this.magic = magic;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyMessage)) {
            return false;
        }
        ProxyMessage other = (ProxyMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getVersion();
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyMessage(magic=" + this.getMagic() + ", version=" + this.getVersion() + ", type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
    }
}

