/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsServiceManager {
    private static final Logger log = LoggerFactory.getLogger(WindowsServiceManager.class);
    private static final String TASK_NAME = "MisebFrpClient";
    private static final String TASK_DISPLAY_NAME = "MISEB FRP Client";
    private static final String TASK_DESCRIPTION = "MISEB\u591a\u5546\u6237\u7535\u5546\u7cfb\u7edf\u5185\u7f51\u7a7f\u900f\u5ba2\u6237\u7aef";

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().contains("windows");
    }

    public static boolean isRunAsAdmin() {
        if (!WindowsServiceManager.isWindows()) {
            return false;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder("net", "session");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isServiceInstalled() {
        if (!WindowsServiceManager.isWindows()) {
            return false;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/Query", "/TN", TASK_NAME);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4efb\u52a1\u72b6\u6001\u5931\u8d25", e);
            return false;
        }
    }

    public static boolean isServiceRunning() {
        if (!WindowsServiceManager.isWindows()) {
            return false;
        }
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/Query", "/TN", TASK_NAME, "/V", "/FO", "LIST");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("GBK")));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("\u72b6\u6001:") && !line.startsWith("Status:")) continue;
                String status = line.substring(line.indexOf(":") + 1).trim();
                return status.contains("\u6b63\u5728\u8fd0\u884c") || status.equalsIgnoreCase("Running");
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4efb\u52a1\u8fd0\u884c\u72b6\u6001\u5931\u8d25", e);
            return false;
        }
    }

    public static ServiceResult installService() {
        if (!WindowsServiceManager.isWindows()) {
            return new ServiceResult(false, "\u6b64\u529f\u80fd\u4ec5\u652f\u6301Windows\u7cfb\u7edf");
        }
        if (!WindowsServiceManager.isRunAsAdmin()) {
            return new ServiceResult(false, "\u8bf7\u4ee5\u7ba1\u7406\u5458\u6743\u9650\u8fd0\u884c\u7a0b\u5e8f");
        }
        if (WindowsServiceManager.isServiceInstalled()) {
            return new ServiceResult(false, "\u81ea\u542f\u52a8\u4efb\u52a1\u5df2\u5b89\u88c5");
        }
        try {
            String jarPath = WindowsServiceManager.getJarPath();
            if (jarPath == null) {
                return new ServiceResult(false, "\u65e0\u6cd5\u83b7\u53d6\u7a0b\u5e8f\u8def\u5f84");
            }
            String javaHome = System.getProperty("java.home");
            String javawPath = javaHome + File.separator + "bin" + File.separator + "javaw.exe";
            String command = "\"" + javawPath + "\" -jar \"" + jarPath + "\" --service";
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/Create", "/TN", TASK_NAME, "/TR", command, "/SC", "ONLOGON", "/RL", "HIGHEST", "/F");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            String output = WindowsServiceManager.readProcessOutput(process);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return new ServiceResult(true, "\u81ea\u542f\u52a8\u4efb\u52a1\u5b89\u88c5\u6210\u529f\n\u7a0b\u5e8f\u5c06\u5728\u4e0b\u6b21\u767b\u5f55\u65f6\u81ea\u52a8\u542f\u52a8");
            }
            return new ServiceResult(false, "\u5b89\u88c5\u5931\u8d25: " + output);
        }
        catch (Exception e) {
            log.error("\u5b89\u88c5\u4efb\u52a1\u5931\u8d25", e);
            return new ServiceResult(false, "\u5b89\u88c5\u5931\u8d25: " + e.getMessage());
        }
    }

    public static ServiceResult uninstallService() {
        if (!WindowsServiceManager.isWindows()) {
            return new ServiceResult(false, "\u6b64\u529f\u80fd\u4ec5\u652f\u6301Windows\u7cfb\u7edf");
        }
        if (!WindowsServiceManager.isRunAsAdmin()) {
            return new ServiceResult(false, "\u8bf7\u4ee5\u7ba1\u7406\u5458\u6743\u9650\u8fd0\u884c\u7a0b\u5e8f");
        }
        if (!WindowsServiceManager.isServiceInstalled()) {
            return new ServiceResult(false, "\u81ea\u542f\u52a8\u4efb\u52a1\u672a\u5b89\u88c5");
        }
        try {
            WindowsServiceManager.stopService();
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/Delete", "/TN", TASK_NAME, "/F");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            String output = WindowsServiceManager.readProcessOutput(process);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return new ServiceResult(true, "\u81ea\u542f\u52a8\u4efb\u52a1\u5378\u8f7d\u6210\u529f");
            }
            return new ServiceResult(false, "\u5378\u8f7d\u5931\u8d25: " + output);
        }
        catch (Exception e) {
            log.error("\u5378\u8f7d\u4efb\u52a1\u5931\u8d25", e);
            return new ServiceResult(false, "\u5378\u8f7d\u5931\u8d25: " + e.getMessage());
        }
    }

    public static ServiceResult startService() {
        if (!WindowsServiceManager.isWindows()) {
            return new ServiceResult(false, "\u6b64\u529f\u80fd\u4ec5\u652f\u6301Windows\u7cfb\u7edf");
        }
        if (!WindowsServiceManager.isServiceInstalled()) {
            return new ServiceResult(false, "\u81ea\u542f\u52a8\u4efb\u52a1\u672a\u5b89\u88c5");
        }
        try {
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/Run", "/TN", TASK_NAME);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            String output = WindowsServiceManager.readProcessOutput(process);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return new ServiceResult(true, "\u4efb\u52a1\u542f\u52a8\u6210\u529f");
            }
            return new ServiceResult(false, "\u542f\u52a8\u5931\u8d25: " + output);
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u4efb\u52a1\u5931\u8d25", e);
            return new ServiceResult(false, "\u542f\u52a8\u5931\u8d25: " + e.getMessage());
        }
    }

    public static ServiceResult stopService() {
        if (!WindowsServiceManager.isWindows()) {
            return new ServiceResult(false, "\u6b64\u529f\u80fd\u4ec5\u652f\u6301Windows\u7cfb\u7edf");
        }
        if (!WindowsServiceManager.isServiceInstalled()) {
            return new ServiceResult(false, "\u81ea\u542f\u52a8\u4efb\u52a1\u672a\u5b89\u88c5");
        }
        try {
            ProcessBuilder builder = new ProcessBuilder("schtasks", "/End", "/TN", TASK_NAME);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            String output = WindowsServiceManager.readProcessOutput(process);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return new ServiceResult(true, "\u4efb\u52a1\u505c\u6b62\u6210\u529f");
            }
            return new ServiceResult(false, "\u505c\u6b62\u5931\u8d25: " + output);
        }
        catch (Exception e) {
            log.error("\u505c\u6b62\u4efb\u52a1\u5931\u8d25", e);
            return new ServiceResult(false, "\u505c\u6b62\u5931\u8d25: " + e.getMessage());
        }
    }

    private static String getJarPath() {
        try {
            String path = WindowsServiceManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (path.startsWith("/") && path.contains(":")) {
                path = path.substring(1);
            }
            return path;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6JAR\u8def\u5f84\u5931\u8d25", e);
            return null;
        }
    }

    private static String readProcessOutput(Process process) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("GBK")));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            return sb.toString().trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getServiceName() {
        return TASK_NAME;
    }

    public static String getServiceDisplayName() {
        return TASK_DISPLAY_NAME;
    }

    public static class ServiceResult {
        private final boolean success;
        private final String message;

        public ServiceResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

