/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconManager {
    private static final Logger log = LoggerFactory.getLogger(IconManager.class);
    private static final String ICON_PATH = "/icons/logo.png";
    private static final String ICON_16_PATH = "/icons/miseb-logo-16.png";
    private static final String ICON_32_PATH = "/icons/miseb-logo-32.png";
    private static final String ICON_48_PATH = "/icons/miseb-logo-48.png";
    private static final String ICON_64_PATH = "/icons/miseb-logo-64.png";
    private static Image cachedIcon;
    private static Image cachedTrayIcon;
    private static List<Image> cachedIconList;

    public static Image getAppIcon() {
        if (cachedIcon == null) {
            cachedIcon = IconManager.loadIcon(ICON_PATH, 64);
            if (cachedIcon == null) {
                cachedIcon = IconManager.loadIcon(ICON_64_PATH, 64);
            }
            if (cachedIcon == null) {
                cachedIcon = IconManager.createDefaultIcon(64);
            }
        }
        return cachedIcon;
    }

    public static Image getTrayIcon() {
        if (cachedTrayIcon == null) {
            cachedTrayIcon = IconManager.loadIcon(ICON_16_PATH, 16);
            if (cachedTrayIcon == null) {
                cachedTrayIcon = IconManager.loadIcon(ICON_PATH, 16);
            }
            if (cachedTrayIcon == null) {
                cachedTrayIcon = IconManager.createDefaultIcon(16);
            }
        }
        return cachedTrayIcon;
    }

    public static List<Image> getAppIconList() {
        if (cachedIconList == null) {
            cachedIconList = new ArrayList<Image>();
            int[] sizes = new int[]{16, 32, 48, 64};
            String[] paths = new String[]{ICON_16_PATH, ICON_32_PATH, ICON_48_PATH, ICON_64_PATH};
            for (int i = 0; i < sizes.length; ++i) {
                Image icon = IconManager.loadIcon(paths[i], sizes[i]);
                if (icon == null) {
                    icon = IconManager.loadIcon(ICON_PATH, sizes[i]);
                }
                if (icon == null) {
                    icon = IconManager.createDefaultIcon(sizes[i]);
                }
                cachedIconList.add(icon);
            }
        }
        return cachedIconList;
    }

    private static Image loadIcon(String path, int size) {
        try {
            BufferedImage image;
            URL url = IconManager.class.getResource(path);
            if (url != null && (image = ImageIO.read(url)) != null) {
                return image.getScaledInstance(size, size, 4);
            }
        }
        catch (Exception e) {
            log.debug("\u52a0\u8f7d\u56fe\u6807\u5931\u8d25: {}", (Object)path);
        }
        return null;
    }

    public static Image createDefaultIcon(int size) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(new Color(45, 45, 45));
        g2d.fillOval(0, 0, size, size);
        g2d.setColor(Color.WHITE);
        int fontSize = Math.max(size / 3, 8);
        g2d.setFont(new Font("Arial", 1, fontSize));
        FontMetrics fm = g2d.getFontMetrics();
        String text = "M";
        int x = (size - fm.stringWidth(text)) / 2;
        int y = (size - fm.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.dispose();
        return image;
    }

    public static Image createStatusTrayIcon(boolean connected) {
        int size = 16;
        Image baseIcon = IconManager.loadIcon(ICON_16_PATH, size);
        if (baseIcon == null) {
            baseIcon = IconManager.loadIcon(ICON_PATH, size);
        }
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (baseIcon != null) {
            g2d.drawImage(baseIcon, 0, 0, size, size, null);
            int dotSize = 6;
            int dotX = size - dotSize;
            int dotY = size - dotSize;
            g2d.setColor(Color.WHITE);
            g2d.fillOval(dotX - 1, dotY - 1, dotSize + 2, dotSize + 2);
            if (connected) {
                g2d.setColor(new Color(46, 204, 113));
            } else {
                g2d.setColor(new Color(231, 76, 60));
            }
            g2d.fillOval(dotX, dotY, dotSize, dotSize);
        } else {
            if (connected) {
                g2d.setColor(new Color(46, 204, 113));
            } else {
                g2d.setColor(new Color(231, 76, 60));
            }
            g2d.fillOval(1, 1, size - 2, size - 2);
            g2d.setColor(Color.WHITE);
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawOval(1, 1, size - 2, size - 2);
            g2d.setColor(Color.WHITE);
            g2d.setFont(new Font("Arial", 1, 10));
            FontMetrics fm = g2d.getFontMetrics();
            String text = "M";
            int x = (size - fm.stringWidth(text)) / 2;
            int y = (size - fm.getHeight()) / 2 + fm.getAscent();
            g2d.drawString(text, x, y);
        }
        g2d.dispose();
        return image;
    }

    public static void setFrameIcon(JFrame frame) {
        try {
            frame.setIconImages(IconManager.getAppIconList());
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u7a97\u53e3\u56fe\u6807\u5931\u8d25", e);
            frame.setIconImage(IconManager.getAppIcon());
        }
    }
}

