/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.ui;

import com.cdiwit.miseb.frp.client.config.ClientConfig;
import com.cdiwit.miseb.frp.client.config.ConfigManager;
import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import com.cdiwit.miseb.frp.client.netty.ConnectionListener;
import com.cdiwit.miseb.frp.client.netty.TunnelClient;
import com.cdiwit.miseb.frp.client.service.WindowsServiceManager;
import com.cdiwit.miseb.frp.client.ui.IconManager;
import com.cdiwit.miseb.frp.client.ui.ProxyConfigDialog;
import com.cdiwit.miseb.frp.client.ui.SystemTrayManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrame
extends JFrame
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(MainFrame.class);
    private final ConfigManager configManager;
    private TunnelClient tunnelClient;
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    private final AtomicLong totalInBytes = new AtomicLong(0L);
    private final AtomicLong totalOutBytes = new AtomicLong(0L);
    private final AtomicLong lastInBytes = new AtomicLong(0L);
    private final AtomicLong lastOutBytes = new AtomicLong(0L);
    private volatile long inSpeed = 0L;
    private volatile long outSpeed = 0L;
    private Timer speedTimer;
    private SystemTrayManager trayManager;
    private JTextField serverHostField;
    private JTextField serverPortField;
    private JTextField authCodeField;
    private JLabel clientIdLabel;
    private JLabel statusLabel;
    private JButton connectButton;
    private JButton cancelButton;
    private JButton disconnectButton;
    private JTable proxyTable;
    private DefaultTableModel proxyTableModel;
    private JTextArea logArea;
    private JLabel trafficLabel;
    private JButton serviceInstallButton;
    private JButton serviceUninstallButton;
    private JLabel serviceStatusLabel;

    public MainFrame() {
        this.configManager = ConfigManager.getInstance();
        this.initUI();
        this.initSystemTray();
        this.loadConfig();
        this.updateServiceStatus();
    }

    private void initUI() {
        this.setTitle("MISEB FRP\u5ba2\u6237\u7aef v1.0.0");
        this.setSize(750, 650);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        IconManager.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.handleWindowClosing();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                ClientConfig config = MainFrame.this.configManager.getClientConfig();
                if (config.isMinimizeToTray() && MainFrame.this.trayManager != null && MainFrame.this.trayManager.isInitialized()) {
                    MainFrame.this.trayManager.minimizeToTray();
                }
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)this.createServerPanel(), "North");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.createProxyPanel());
        splitPane.setBottomComponent(this.createLogPanel());
        splitPane.setResizeWeight(0.6);
        mainPanel.add((Component)splitPane, "Center");
        mainPanel.add((Component)this.createStatusBar(), "South");
        this.setContentPane(mainPanel);
    }

    private void initSystemTray() {
        this.trayManager = new SystemTrayManager(this);
        if (this.trayManager.initialize()) {
            this.trayManager.setCallbacks(this::handleConnect, this::handleDisconnect, this::handleExit);
        }
    }

    private JPanel createServerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u670d\u52a1\u5668\u914d\u7f6e"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("\u670d\u52a1\u5668\u5730\u5740:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.serverHostField = new JTextField(20);
        panel.add((Component)this.serverHostField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel("\u7aef\u53e3:"), gbc);
        gbc.gridx = 3;
        this.serverPortField = new JTextField(6);
        panel.add((Component)this.serverPortField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("\u6388\u6743\u7801:"), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.authCodeField = new JTextField(30);
        panel.add((Component)this.authCodeField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        panel.add((Component)new JLabel("\u5ba2\u6237\u7aefID:"), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        this.clientIdLabel = new JLabel("");
        this.clientIdLabel.setForeground(Color.GRAY);
        panel.add((Component)this.clientIdLabel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JButton copyClientIdButton = new JButton("\u590d\u5236");
        copyClientIdButton.setMargin(new Insets(2, 8, 2, 8));
        copyClientIdButton.addActionListener(e -> {
            String clientId = this.clientIdLabel.getText();
            if (clientId != null && !clientId.isEmpty()) {
                StringSelection selection = new StringSelection(clientId);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
                this.appendLog("\u5ba2\u6237\u7aefID\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f");
            }
        });
        panel.add((Component)copyClientIdButton, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.fill = 1;
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.connectButton = new JButton("\u8fde\u63a5");
        this.connectButton.addActionListener(e -> this.handleConnect());
        this.cancelButton = new JButton("\u53d6\u6d88\u8fde\u63a5");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(e -> this.handleCancelConnect());
        this.disconnectButton = new JButton("\u65ad\u5f00");
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.addActionListener(e -> this.handleDisconnect());
        buttonPanel.add(this.connectButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.disconnectButton);
        panel.add((Component)buttonPanel, gbc);
        if (WindowsServiceManager.isWindows()) {
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.fill = 2;
            panel.add((Component)this.createServicePanel(), gbc);
        }
        return panel;
    }

    private JPanel createServicePanel() {
        JPanel panel = new JPanel(new FlowLayout(0, 10, 5));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        panel.add(new JLabel("\u5f00\u673a\u81ea\u542f:"));
        this.serviceStatusLabel = new JLabel("\u68c0\u67e5\u4e2d...");
        panel.add(this.serviceStatusLabel);
        this.serviceInstallButton = new JButton("\u542f\u7528\u81ea\u542f\u52a8");
        this.serviceInstallButton.addActionListener(e -> this.handleInstallService());
        panel.add(this.serviceInstallButton);
        this.serviceUninstallButton = new JButton("\u7981\u7528\u81ea\u542f\u52a8");
        this.serviceUninstallButton.addActionListener(e -> this.handleUninstallService());
        panel.add(this.serviceUninstallButton);
        JButton refreshButton = new JButton("\u5237\u65b0");
        refreshButton.addActionListener(e -> this.updateServiceStatus());
        panel.add(refreshButton);
        return panel;
    }

    private void updateServiceStatus() {
        if (!WindowsServiceManager.isWindows()) {
            return;
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            boolean installed;
            boolean running;

            @Override
            protected Void doInBackground() {
                this.installed = WindowsServiceManager.isServiceInstalled();
                this.running = WindowsServiceManager.isServiceRunning();
                return null;
            }

            @Override
            protected void done() {
                if (this.installed) {
                    if (this.running) {
                        MainFrame.this.serviceStatusLabel.setText("\u5df2\u542f\u7528(\u8fd0\u884c\u4e2d)");
                        MainFrame.this.serviceStatusLabel.setForeground(new Color(0, 128, 0));
                    } else {
                        MainFrame.this.serviceStatusLabel.setText("\u5df2\u542f\u7528");
                        MainFrame.this.serviceStatusLabel.setForeground(new Color(0, 128, 0));
                    }
                    MainFrame.this.serviceInstallButton.setEnabled(false);
                    MainFrame.this.serviceUninstallButton.setEnabled(true);
                } else {
                    MainFrame.this.serviceStatusLabel.setText("\u672a\u542f\u7528");
                    MainFrame.this.serviceStatusLabel.setForeground(Color.GRAY);
                    MainFrame.this.serviceInstallButton.setEnabled(true);
                    MainFrame.this.serviceUninstallButton.setEnabled(false);
                }
            }
        };
        worker.execute();
    }

    private void handleInstallService() {
        if (!WindowsServiceManager.isRunAsAdmin()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u4ee5\u7ba1\u7406\u5458\u6743\u9650\u8fd0\u884c\u7a0b\u5e8f\u540e\u518d\u8bbe\u7f6e\u81ea\u542f\u52a8", "\u6743\u9650\u4e0d\u8db3", 2);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u8981\u8bbe\u7f6e\u5f00\u673a\u81ea\u52a8\u542f\u52a8\u5417\uff1f\n\u7a0b\u5e8f\u5c06\u5728\u7528\u6237\u767b\u5f55\u65f6\u81ea\u52a8\u8fd0\u884c\u3002", "\u786e\u8ba4", 0);
        if (confirm != 0) {
            return;
        }
        this.serviceInstallButton.setEnabled(false);
        this.serviceStatusLabel.setText("\u8bbe\u7f6e\u4e2d...");
        this.serviceStatusLabel.setForeground(Color.ORANGE);
        SwingWorker<WindowsServiceManager.ServiceResult, String> worker = new SwingWorker<WindowsServiceManager.ServiceResult, String>(){

            @Override
            protected WindowsServiceManager.ServiceResult doInBackground() {
                return WindowsServiceManager.installService();
            }

            @Override
            protected void done() {
                try {
                    WindowsServiceManager.ServiceResult result = (WindowsServiceManager.ServiceResult)this.get();
                    if (result.isSuccess()) {
                        MainFrame.this.appendLog("\u5f00\u673a\u81ea\u542f\u52a8\u8bbe\u7f6e\u6210\u529f");
                        JOptionPane.showMessageDialog(MainFrame.this, result.getMessage(), "\u8bbe\u7f6e\u6210\u529f", 1);
                    } else {
                        MainFrame.this.appendLog("\u5f00\u673a\u81ea\u542f\u52a8\u8bbe\u7f6e\u5931\u8d25: " + result.getMessage());
                        JOptionPane.showMessageDialog(MainFrame.this, result.getMessage(), "\u8bbe\u7f6e\u5931\u8d25", 0);
                    }
                }
                catch (Exception e) {
                    MainFrame.this.appendLog("\u5f00\u673a\u81ea\u542f\u52a8\u8bbe\u7f6e\u5f02\u5e38: " + e.getMessage());
                    JOptionPane.showMessageDialog(MainFrame.this, "\u8bbe\u7f6e\u5f02\u5e38: " + e.getMessage(), "\u8bbe\u7f6e\u5931\u8d25", 0);
                }
                MainFrame.this.updateServiceStatus();
            }
        };
        worker.execute();
    }

    private void handleUninstallService() {
        if (!WindowsServiceManager.isRunAsAdmin()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u4ee5\u7ba1\u7406\u5458\u6743\u9650\u8fd0\u884c\u7a0b\u5e8f\u540e\u518d\u53d6\u6d88\u81ea\u542f\u52a8", "\u6743\u9650\u4e0d\u8db3", 2);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u8981\u53d6\u6d88\u5f00\u673a\u81ea\u52a8\u542f\u52a8\u5417\uff1f", "\u786e\u8ba4", 0);
        if (confirm != 0) {
            return;
        }
        WindowsServiceManager.ServiceResult result = WindowsServiceManager.uninstallService();
        if (result.isSuccess()) {
            this.appendLog("\u5f00\u673a\u81ea\u542f\u52a8\u5df2\u53d6\u6d88");
            JOptionPane.showMessageDialog(this, result.getMessage(), "\u53d6\u6d88\u6210\u529f", 1);
        } else {
            this.appendLog("\u53d6\u6d88\u81ea\u542f\u52a8\u5931\u8d25: " + result.getMessage());
            JOptionPane.showMessageDialog(this, result.getMessage(), "\u53d6\u6d88\u5931\u8d25", 0);
        }
        this.updateServiceStatus();
    }

    private JPanel createProxyPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new TitledBorder("\u4ee3\u7406\u914d\u7f6e"));
        Object[] columns = new String[]{"\u4ee3\u7406\u540d\u79f0", "\u672c\u5730\u5730\u5740", "\u672c\u5730\u7aef\u53e3", "\u8fdc\u7a0b\u7aef\u53e3", "\u72b6\u6001", "\u542f\u7528"};
        this.proxyTableModel = new DefaultTableModel(columns, 0){

            @Override
            public Class<?> getColumnClass(int column) {
                return column == 5 ? Boolean.class : String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 5;
            }
        };
        this.proxyTable = new JTable(this.proxyTableModel);
        this.proxyTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.proxyTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.proxyTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.proxyTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.proxyTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.proxyTable.getColumnModel().getColumn(5).setPreferredWidth(50);
        panel.add((Component)new JScrollPane(this.proxyTable), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JButton addButton = new JButton("\u6dfb\u52a0");
        addButton.addActionListener(e -> this.handleAddProxy());
        JButton removeButton = new JButton("\u5220\u9664");
        removeButton.addActionListener(e -> this.handleRemoveProxy());
        JButton saveButton = new JButton("\u4fdd\u5b58\u914d\u7f6e");
        saveButton.addActionListener(e -> this.handleSaveConfig());
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(saveButton);
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel createLogPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("\u8fd0\u884c\u65e5\u5fd7"));
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setFont(new Font("Monospaced", 0, 12));
        panel.add((Component)new JScrollPane(this.logArea), "Center");
        JButton clearButton = new JButton("\u6e05\u9664\u65e5\u5fd7");
        clearButton.addActionListener(e -> this.logArea.setText(""));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(clearButton);
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel createStatusBar() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.statusLabel = new JLabel(" \u672a\u8fde\u63a5");
        this.statusLabel.setForeground(Color.RED);
        panel.add((Component)this.statusLabel, "West");
        this.trafficLabel = new JLabel("\u5165\u7ad9: 0 B  \u51fa\u7ad9: 0 B ");
        panel.add((Component)this.trafficLabel, "East");
        return panel;
    }

    private void loadConfig() {
        this.configManager.load();
        ClientConfig config = this.configManager.getClientConfig();
        this.serverHostField.setText(config.getServerHost());
        this.serverPortField.setText(String.valueOf(config.getServerPort()));
        this.authCodeField.setText(config.getAuthCode());
        this.clientIdLabel.setText(config.getClientId());
        this.proxyTableModel.setRowCount(0);
        for (ProxyConfig proxy : this.configManager.getProxyConfigs()) {
            this.proxyTableModel.addRow(new Object[]{proxy.getProxyName(), proxy.getLocalIp(), proxy.getLocalPort(), proxy.getRemotePort() > 0 ? Integer.valueOf(proxy.getRemotePort()) : "\u81ea\u52a8", "\u672a\u8fde\u63a5", proxy.isEnabled()});
        }
        this.appendLog("\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210");
    }

    private void handleConnect() {
        int port;
        if (this.connectionState == ConnectionState.CONNECTED || this.connectionState == ConnectionState.CONNECTING || this.connectionState == ConnectionState.RECONNECTING) {
            return;
        }
        String host = this.serverHostField.getText().trim();
        String portStr = this.serverPortField.getText().trim();
        String authCode = this.authCodeField.getText().trim();
        if (host.isEmpty() || portStr.isEmpty() || authCode.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u670d\u52a1\u5668\u914d\u7f6e", "\u63d0\u793a", 2);
            return;
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\u7aef\u53e3\u683c\u5f0f\u4e0d\u6b63\u786e", "\u9519\u8bef", 0);
            return;
        }
        ClientConfig config = this.configManager.getClientConfig();
        config.setServerHost(host);
        config.setServerPort(port);
        config.setAuthCode(authCode);
        List<ProxyConfig> proxies = this.configManager.getProxyConfigs();
        for (int i = 0; i < this.proxyTableModel.getRowCount(); ++i) {
            if (i >= proxies.size()) continue;
            proxies.get(i).setEnabled((Boolean)this.proxyTableModel.getValueAt(i, 5));
        }
        this.tunnelClient = new TunnelClient(config, proxies, this);
        this.updateConnectionState(ConnectionState.CONNECTING);
        this.tunnelClient.connect();
    }

    private void handleCancelConnect() {
        if (this.tunnelClient != null) {
            this.tunnelClient.cancelConnect();
        }
        this.updateConnectionState(ConnectionState.DISCONNECTED);
    }

    private void handleDisconnect() {
        if (this.tunnelClient != null) {
            this.tunnelClient.disconnect();
        }
        this.updateConnectionState(ConnectionState.DISCONNECTED);
    }

    private void updateConnectionState(ConnectionState state) {
        this.connectionState = state;
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(" " + state.text);
            this.statusLabel.setForeground(state.color);
            boolean isIdle = state == ConnectionState.DISCONNECTED || state == ConnectionState.CONNECT_FAILED;
            boolean isConnecting = state == ConnectionState.CONNECTING || state == ConnectionState.RECONNECTING;
            boolean isConnected = state == ConnectionState.CONNECTED;
            this.connectButton.setEnabled(isIdle);
            this.cancelButton.setEnabled(isConnecting);
            this.disconnectButton.setEnabled(isConnected);
            this.serverHostField.setEnabled(isIdle);
            this.serverPortField.setEnabled(isIdle);
            this.authCodeField.setEnabled(isIdle);
            if (this.trayManager != null) {
                this.trayManager.updateConnectionStatus(isConnected);
            }
        });
    }

    private void handleAddProxy() {
        ProxyConfigDialog dialog = new ProxyConfigDialog(this);
        dialog.setVisible(true);
        if (dialog.isConfirmed()) {
            ProxyConfig proxy = dialog.getProxyConfig();
            this.configManager.addProxyConfig(proxy);
            this.proxyTableModel.addRow(new Object[]{proxy.getProxyName(), proxy.getLocalIp(), proxy.getLocalPort(), proxy.getRemotePort() > 0 ? Integer.valueOf(proxy.getRemotePort()) : "\u81ea\u52a8", "\u672a\u8fde\u63a5", proxy.isEnabled()});
            this.appendLog("\u6dfb\u52a0\u4ee3\u7406: " + proxy.getProxyName());
        }
    }

    private void handleRemoveProxy() {
        int row = this.proxyTable.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4ee3\u7406", "\u63d0\u793a", 2);
            return;
        }
        String proxyName = (String)this.proxyTableModel.getValueAt(row, 0);
        int confirm = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u5220\u9664\u4ee3\u7406 " + proxyName + " ?", "\u786e\u8ba4", 0);
        if (confirm == 0) {
            this.configManager.getProxyConfigs().remove(row);
            this.proxyTableModel.removeRow(row);
            this.appendLog("\u5220\u9664\u4ee3\u7406: " + proxyName);
        }
    }

    private void handleSaveConfig() {
        ClientConfig config = this.configManager.getClientConfig();
        config.setServerHost(this.serverHostField.getText().trim());
        try {
            config.setServerPort(Integer.parseInt(this.serverPortField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        config.setAuthCode(this.authCodeField.getText().trim());
        this.configManager.save();
        this.appendLog("\u914d\u7f6e\u5df2\u4fdd\u5b58");
        JOptionPane.showMessageDialog(this, "\u914d\u7f6e\u4fdd\u5b58\u6210\u529f", "\u63d0\u793a", 1);
    }

    public void autoConnect() {
        Timer timer = new Timer(1000, e -> this.handleConnect());
        timer.setRepeats(false);
        timer.start();
    }

    private void handleWindowClosing() {
        ClientConfig config = this.configManager.getClientConfig();
        if (config.isMinimizeToTray() && this.trayManager != null && this.trayManager.isInitialized()) {
            this.trayManager.minimizeToTray();
            return;
        }
        this.handleExit();
    }

    private void handleExit() {
        int confirm = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", "\u786e\u8ba4", 0);
        if (confirm == 0) {
            this.doExit();
        }
    }

    private void doExit() {
        this.stopSpeedTimer();
        if (this.tunnelClient != null) {
            this.tunnelClient.disconnect();
        }
        if (this.trayManager != null) {
            this.trayManager.remove();
        }
        this.configManager.save();
        System.exit(0);
    }

    private void appendLog(String message) {
        SwingUtilities.invokeLater(() -> {
            String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
            this.logArea.append("[" + time + "] " + message + "\n");
            this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
        });
    }

    private void updateProxyStatus(String proxyName, String status) {
        SwingUtilities.invokeLater(() -> {
            for (int i = 0; i < this.proxyTableModel.getRowCount(); ++i) {
                if (!proxyName.equals(this.proxyTableModel.getValueAt(i, 0))) continue;
                this.proxyTableModel.setValueAt(status, i, 4);
                break;
            }
        });
    }

    private void updateProxyRemotePort(String proxyName, int remotePort) {
        SwingUtilities.invokeLater(() -> {
            for (int i = 0; i < this.proxyTableModel.getRowCount(); ++i) {
                if (!proxyName.equals(this.proxyTableModel.getValueAt(i, 0))) continue;
                this.proxyTableModel.setValueAt(remotePort, i, 3);
                break;
            }
        });
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    @Override
    public void onConnected() {
        this.totalInBytes.set(0L);
        this.totalOutBytes.set(0L);
        this.lastInBytes.set(0L);
        this.lastOutBytes.set(0L);
        this.inSpeed = 0L;
        this.outSpeed = 0L;
        this.startSpeedTimer();
        SwingUtilities.invokeLater(() -> this.updateTrafficLabel());
        this.updateConnectionState(ConnectionState.CONNECTED);
    }

    @Override
    public void onDisconnected() {
        this.stopSpeedTimer();
        this.updateConnectionState(ConnectionState.DISCONNECTED);
        SwingUtilities.invokeLater(() -> {
            for (int i = 0; i < this.proxyTableModel.getRowCount(); ++i) {
                this.proxyTableModel.setValueAt("\u672a\u8fde\u63a5", i, 4);
            }
        });
    }

    @Override
    public void onConnectFailed(String reason) {
        this.updateConnectionState(ConnectionState.CONNECT_FAILED);
    }

    @Override
    public void onReconnecting(int attempt, int remainingSeconds) {
        SwingUtilities.invokeLater(() -> {
            this.connectionState = ConnectionState.RECONNECTING;
            this.statusLabel.setText(String.format(" \u91cd\u8fde\u4e2d (\u7b2c%d\u6b21, %d\u79d2\u540e\u91cd\u8bd5)", attempt, remainingSeconds));
            this.statusLabel.setForeground(Color.ORANGE);
            this.connectButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
        });
    }

    @Override
    public void onAuthenticated(String sessionId, List<Integer> allocatedPorts) {
        this.appendLog("\u8ba4\u8bc1\u6210\u529f\uff0c\u5206\u914d\u7aef\u53e3: " + allocatedPorts);
    }

    @Override
    public void onAuthFailed(String reason) {
        this.appendLog("\u8ba4\u8bc1\u5931\u8d25: " + reason);
        this.updateConnectionState(ConnectionState.CONNECT_FAILED);
    }

    @Override
    public void onProxyRegistered(String proxyName, int remotePort) {
        this.updateProxyStatus(proxyName, "\u5df2\u8fde\u63a5");
        this.updateProxyRemotePort(proxyName, remotePort);
    }

    @Override
    public void onProxyRegisterFailed(String proxyName, String reason) {
        this.updateProxyStatus(proxyName, "\u5931\u8d25");
        this.appendLog("\u4ee3\u7406 " + proxyName + " \u6ce8\u518c\u5931\u8d25: " + reason);
    }

    @Override
    public void onLog(String message) {
        this.appendLog(message);
    }

    @Override
    public void onTrafficUpdate(long inBytes, long outBytes) {
        this.totalInBytes.addAndGet(inBytes);
        this.totalOutBytes.addAndGet(outBytes);
        SwingUtilities.invokeLater(this::updateTrafficLabel);
    }

    private void startSpeedTimer() {
        this.stopSpeedTimer();
        this.speedTimer = new Timer(1000, e -> {
            long currentIn = this.totalInBytes.get();
            long currentOut = this.totalOutBytes.get();
            this.inSpeed = currentIn - this.lastInBytes.get();
            this.outSpeed = currentOut - this.lastOutBytes.get();
            this.lastInBytes.set(currentIn);
            this.lastOutBytes.set(currentOut);
            this.updateTrafficLabel();
        });
        this.speedTimer.start();
    }

    private void stopSpeedTimer() {
        if (this.speedTimer != null) {
            this.speedTimer.stop();
            this.speedTimer = null;
        }
    }

    private void updateTrafficLabel() {
        String inSpeedStr = this.inSpeed > 0L ? " (" + this.formatSpeed(this.inSpeed) + ")" : "";
        String outSpeedStr = this.outSpeed > 0L ? " (" + this.formatSpeed(this.outSpeed) + ")" : "";
        this.trafficLabel.setText("\u2193 " + this.formatBytes(this.totalInBytes.get()) + inSpeedStr + "  \u2191 " + this.formatBytes(this.totalOutBytes.get()) + outSpeedStr + " ");
    }

    private String formatSpeed(long bytesPerSecond) {
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        if (bytesPerSecond < 0x100000L) {
            return String.format("%.1f KB/s", (double)bytesPerSecond / 1024.0);
        }
        return String.format("%.1f MB/s", (double)bytesPerSecond / 1048576.0);
    }

    private static enum ConnectionState {
        DISCONNECTED("\u672a\u8fde\u63a5", Color.RED),
        CONNECTING("\u8fde\u63a5\u4e2d...", Color.ORANGE),
        CONNECTED("\u5df2\u8fde\u63a5", new Color(0, 128, 0)),
        RECONNECTING("\u91cd\u8fde\u4e2d...", Color.ORANGE),
        CONNECT_FAILED("\u8fde\u63a5\u5931\u8d25", Color.RED);

        private final String text;
        private final Color color;

        private ConnectionState(String text, Color color) {
            this.text = text;
            this.color = color;
        }
    }
}

