/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.ui;

import com.cdiwit.miseb.frp.client.config.ProxyConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProxyConfigDialog
extends JDialog {
    private JTextField proxyNameField;
    private JComboBox<String> proxyTypeCombo;
    private JTextField localIpField;
    private JTextField localPortField;
    private JTextField remotePortField;
    private JTextField remarkField;
    private JCheckBox enabledCheckBox;
    private boolean confirmed = false;
    private ProxyConfig proxyConfig;

    public ProxyConfigDialog(Frame owner) {
        super(owner, "\u6dfb\u52a0\u4ee3\u7406\u914d\u7f6e", true);
        this.initUI();
        this.setSize(400, 330);
        this.setLocationRelativeTo(owner);
    }

    private void initUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("\u4ee3\u7406\u540d\u79f0:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.proxyNameField = new JTextField(20);
        panel.add((Component)this.proxyNameField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel("\u4ee3\u7406\u7c7b\u578b:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.proxyTypeCombo = new JComboBox<String>(new String[]{"tcp", "udp", "http"});
        panel.add(this.proxyTypeCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        panel.add((Component)new JLabel("\u672c\u5730IP:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.localIpField = new JTextField("127.0.0.1");
        panel.add((Component)this.localIpField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        panel.add((Component)new JLabel("\u672c\u5730\u7aef\u53e3:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.localPortField = new JTextField();
        panel.add((Component)this.localPortField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 0;
        panel.add((Component)new JLabel("\u8fdc\u7a0b\u7aef\u53e3:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.remotePortField = new JTextField();
        this.remotePortField.setToolTipText("\u7559\u7a7a\u8868\u793a\u81ea\u52a8\u5206\u914d");
        panel.add((Component)this.remotePortField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 2;
        JLabel remotePortHint = new JLabel("(\u7559\u7a7a\u5219\u7531\u670d\u52a1\u7aef\u81ea\u52a8\u5206\u914d\u7aef\u53e3)");
        remotePortHint.setFont(remotePortHint.getFont().deriveFont(11.0f));
        remotePortHint.setForeground(Color.GRAY);
        panel.add((Component)remotePortHint, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.fill = 0;
        panel.add((Component)new JLabel("\u5907\u6ce8:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.remarkField = new JTextField();
        panel.add((Component)this.remarkField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        this.enabledCheckBox = new JCheckBox("\u542f\u7528", true);
        panel.add((Component)this.enabledCheckBox, gbc);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("\u786e\u5b9a");
        okButton.addActionListener(e -> this.handleOk());
        JButton cancelButton = new JButton("\u53d6\u6d88");
        cancelButton.addActionListener(e -> this.dispose());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        panel.add((Component)buttonPanel, gbc);
        this.setContentPane(panel);
    }

    private void handleOk() {
        int localPort;
        String proxyName = this.proxyNameField.getText().trim();
        String localIp = this.localIpField.getText().trim();
        String localPortStr = this.localPortField.getText().trim();
        String remotePortStr = this.remotePortField.getText().trim();
        if (proxyName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165\u4ee3\u7406\u540d\u79f0", "\u63d0\u793a", 2);
            return;
        }
        if (localPortStr.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165\u672c\u5730\u7aef\u53e3", "\u63d0\u793a", 2);
            return;
        }
        try {
            localPort = Integer.parseInt(localPortStr);
            if (localPort <= 0 || localPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\u672c\u5730\u7aef\u53e3\u683c\u5f0f\u4e0d\u6b63\u786e", "\u9519\u8bef", 0);
            return;
        }
        int remotePort = 0;
        if (!remotePortStr.isEmpty()) {
            try {
                remotePort = Integer.parseInt(remotePortStr);
                if (remotePort < 0 || remotePort > 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "\u8fdc\u7a0b\u7aef\u53e3\u683c\u5f0f\u4e0d\u6b63\u786e", "\u9519\u8bef", 0);
                return;
            }
        }
        this.proxyConfig = new ProxyConfig();
        this.proxyConfig.setProxyName(proxyName);
        this.proxyConfig.setProxyType((String)this.proxyTypeCombo.getSelectedItem());
        this.proxyConfig.setLocalIp(localIp.isEmpty() ? "127.0.0.1" : localIp);
        this.proxyConfig.setLocalPort(localPort);
        this.proxyConfig.setRemotePort(remotePort);
        this.proxyConfig.setRemark(this.remarkField.getText().trim());
        this.proxyConfig.setEnabled(this.enabledCheckBox.isSelected());
        this.confirmed = true;
        this.dispose();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }
}

