/*
 * Decompiled with CFR 0.152.
 */
package com.cdiwit.miseb.frp.client.ui;

import com.cdiwit.miseb.frp.client.ui.IconManager;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayManager {
    private static final Logger log = LoggerFactory.getLogger(SystemTrayManager.class);
    private final JFrame mainFrame;
    private SystemTray systemTray;
    private TrayIcon trayIcon;
    private boolean connected = false;
    private JPopupMenu popupMenu;
    private JMenuItem connectItem;
    private JMenuItem disconnectItem;
    private JMenuItem showItem;
    private Runnable onConnect;
    private Runnable onDisconnect;
    private Runnable onExit;
    private JFrame menuFrame;
    private PopupMenuListener menuCloseListener;

    public SystemTrayManager(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public boolean initialize() {
        if (!SystemTray.isSupported()) {
            log.warn("\u7cfb\u7edf\u4e0d\u652f\u6301\u6258\u76d8\u529f\u80fd");
            return false;
        }
        try {
            this.systemTray = SystemTray.getSystemTray();
            Image image = IconManager.createStatusTrayIcon(false);
            this.trayIcon = new TrayIcon(image, "MISEB FRP\u5ba2\u6237\u7aef - \u672a\u8fde\u63a5");
            this.trayIcon.setImageAutoSize(true);
            this.popupMenu = this.createSwingPopupMenu();
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        SystemTrayManager.this.showMainFrame();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() == 3) {
                        SystemTrayManager.this.showPopupMenu(e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() == 3) {
                        SystemTrayManager.this.showPopupMenu(e.getX(), e.getY());
                    }
                }
            });
            this.systemTray.add(this.trayIcon);
            log.info("\u7cfb\u7edf\u6258\u76d8\u521d\u59cb\u5316\u6210\u529f");
            return true;
        }
        catch (AWTException e) {
            log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u6258\u76d8\u5931\u8d25", e);
            return false;
        }
    }

    private void showPopupMenu(int x, int y) {
        if (this.menuFrame == null) {
            this.menuFrame = new JFrame();
            this.menuFrame.setUndecorated(true);
            this.menuFrame.setSize(1, 1);
            this.menuFrame.setType(Window.Type.UTILITY);
            this.menuFrame.setAlwaysOnTop(true);
            this.menuCloseListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SystemTrayManager.this.menuFrame.setVisible(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    SystemTrayManager.this.menuFrame.setVisible(false);
                }
            };
            this.popupMenu.addPopupMenuListener(this.menuCloseListener);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        Dimension menuSize = this.popupMenu.getPreferredSize();
        int menuX = x;
        int menuY = y;
        if (x + menuSize.width > screenSize.width - screenInsets.right) {
            menuX = x - menuSize.width;
        }
        if (y + menuSize.height > screenSize.height - screenInsets.bottom) {
            menuY = y - menuSize.height;
        }
        this.menuFrame.setLocation(menuX, menuY);
        this.menuFrame.setVisible(true);
        this.popupMenu.show(this.menuFrame, 0, 0);
    }

    private JPopupMenu createSwingPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.showItem = new JMenuItem("\u663e\u793a\u4e3b\u7a97\u53e3");
        this.showItem.addActionListener(e -> this.showMainFrame());
        menu.add(this.showItem);
        menu.addSeparator();
        this.connectItem = new JMenuItem("\u8fde\u63a5");
        this.connectItem.addActionListener(e -> {
            if (this.onConnect != null) {
                this.onConnect.run();
            }
        });
        menu.add(this.connectItem);
        this.disconnectItem = new JMenuItem("\u65ad\u5f00\u8fde\u63a5");
        this.disconnectItem.setEnabled(false);
        this.disconnectItem.addActionListener(e -> {
            if (this.onDisconnect != null) {
                this.onDisconnect.run();
            }
        });
        menu.add(this.disconnectItem);
        menu.addSeparator();
        JMenuItem exitItem = new JMenuItem("\u9000\u51fa");
        exitItem.addActionListener(e -> {
            if (this.onExit != null) {
                this.onExit.run();
            }
        });
        menu.add(exitItem);
        return menu;
    }

    private void showMainFrame() {
        SwingUtilities.invokeLater(() -> {
            this.mainFrame.setVisible(true);
            this.mainFrame.setState(0);
            this.mainFrame.toFront();
            this.mainFrame.requestFocus();
        });
    }

    public void minimizeToTray() {
        if (this.trayIcon != null) {
            this.mainFrame.setVisible(false);
            this.showToast("\u7a0b\u5e8f\u5df2\u6700\u5c0f\u5316\u5230\u7cfb\u7edf\u6258\u76d8");
        }
    }

    private void showToast(String message) {
        SwingUtilities.invokeLater(() -> {
            JWindow toast = new JWindow();
            toast.setAlwaysOnTop(true);
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(100, 100, 100), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
            panel.setBackground(new Color(50, 50, 50));
            JLabel titleLabel = new JLabel("MISEB FRP\u5ba2\u6237\u7aef");
            titleLabel.setForeground(Color.WHITE);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1, 12.0f));
            panel.add((Component)titleLabel, "North");
            JLabel msgLabel = new JLabel(message);
            msgLabel.setForeground(new Color(200, 200, 200));
            panel.add((Component)msgLabel, "Center");
            toast.add(panel);
            toast.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            int x = screenSize.width - toast.getWidth() - 10;
            int y = screenSize.height - screenInsets.bottom - toast.getHeight() - 10;
            toast.setLocation(x, y);
            toast.setVisible(true);
            Timer timer = new Timer(3000, e -> toast.dispose());
            timer.setRepeats(false);
            timer.start();
        });
    }

    public void updateConnectionStatus(boolean connected) {
        this.connected = connected;
        if (this.trayIcon != null) {
            SwingUtilities.invokeLater(() -> {
                this.trayIcon.setImage(IconManager.createStatusTrayIcon(connected));
                this.trayIcon.setToolTip("MISEB FRP\u5ba2\u6237\u7aef - " + (connected ? "\u5df2\u8fde\u63a5" : "\u672a\u8fde\u63a5"));
                this.connectItem.setEnabled(!connected);
                this.disconnectItem.setEnabled(connected);
            });
        }
    }

    public void showMessage(String caption, String message, TrayIcon.MessageType type) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage(caption, message, type);
        }
    }

    public void setCallbacks(Runnable onConnect, Runnable onDisconnect, Runnable onExit) {
        this.onConnect = onConnect;
        this.onDisconnect = onDisconnect;
        this.onExit = onExit;
    }

    public void remove() {
        if (this.systemTray != null && this.trayIcon != null) {
            this.systemTray.remove(this.trayIcon);
        }
        if (this.menuFrame != null) {
            this.menuFrame.dispose();
            this.menuFrame = null;
        }
    }

    public boolean isInitialized() {
        return this.trayIcon != null;
    }
}

