# MISEB FRP Client 部署说明

## 简介
MISEB FRP Client 是一个内网穿透客户端，用于将本地服务暴露到公网。

## 目录结构
```
miseb-frp-client/
├── jre/                    # Java运行环境（需要自行下载）
├── config/                 # 配置文件目录
│   └── frp-client.json     # 客户端配置文件
├── logs/                   # 日志文件目录
├── miseb-frp-client.jar    # 客户端主程序
├── start.bat               # Windows启动脚本（图形界面）
├── start.sh                # Linux/Mac启动脚本（图形界面）
└── start-headless.sh       # Linux服务器启动脚本（无界面）
```

## 安装步骤

### 1. 准备Java运行环境

需要Java 8运行环境。请下载对应操作系统的JRE并解压到`jre`文件夹中。

**下载地址：**
- 官方下载: https://adoptium.net/releases.html?variant=openjdk8
- 国内镜像: https://mirrors.tuna.tsinghua.edu.cn/Adoptium/

**下载后的目录结构应该是：**
```
jre/
├── bin/
│   ├── java.exe (Windows) 或 java (Linux/Mac)
│   └── ...
├── lib/
└── ...
```

### 2. 配置客户端

1. 复制 `config/frp-client.json.example` 为 `config/frp-client.json`
2. 修改配置文件：
   - `serverHost`: FRP服务器地址
   - `serverPort`: FRP服务器端口（默认7000）
   - `authCode`: 在平台端获取的授权码
   - `proxies`: 代理配置列表

### 3. 启动客户端

**Windows:**
双击 `start.bat` 启动图形界面

**Linux/Mac (图形界面):**
```bash
chmod +x start.sh
./start.sh
```

**Linux服务器 (无界面):**
```bash
chmod +x start-headless.sh
./start-headless.sh start    # 启动
./start-headless.sh stop     # 停止
./start-headless.sh restart  # 重启
./start-headless.sh status   # 查看状态
```

## 配置示例

```json
{
  "serverHost": "frp.example.com",
  "serverPort": 7000,
  "authCode": "ABC123XYZ",
  "proxies": [
    {
      "proxyName": "web",
      "localIp": "127.0.0.1",
      "localPort": 80,
      "remotePort": 8080
    },
    {
      "proxyName": "mysql",
      "localIp": "127.0.0.1",
      "localPort": 3306,
      "remotePort": 13306
    }
  ]
}
```

## 常见问题

### Q: 启动时提示"未找到Java运行环境"
A: 请确保已将Java 8 JRE解压到`jre`文件夹中，且目录结构正确。

### Q: 连接失败
A: 请检查：
1. 服务器地址和端口是否正确
2. 授权码是否有效
3. 网络是否能访问服务器

### Q: 本地端口无法访问
A: 请检查本地服务是否正在运行，以及localIp和localPort配置是否正确。

## 技术支持

- 公司：成都艾唯特软件有限公司
- 邮箱：hongan@cdiwit.com
