#!/bin/bash
# ===================================
# MISEB FRP Client 无界面启动脚本 (Linux服务器)
# 成都艾唯特软件有限公司
# ===================================

cd "$(dirname "$0")"

# 设置JAVA_HOME
export JAVA_HOME="$(pwd)/jre"
export PATH="$JAVA_HOME/bin:$PATH"

# 检查JRE是否存在
if [ ! -f "$JAVA_HOME/bin/java" ]; then
    echo "[错误] 未找到Java运行环境"
    exit 1
fi

# 检查JAR包是否存在
if [ ! -f "miseb-frp-client.jar" ]; then
    echo "[错误] 未找到miseb-frp-client.jar"
    exit 1
fi

# PID文件
PID_FILE="./frp-client.pid"
LOG_FILE="./logs/frp-client.log"

case "$1" in
    start)
        if [ -f "$PID_FILE" ]; then
            PID=$(cat "$PID_FILE")
            if ps -p $PID > /dev/null 2>&1; then
                echo "FRP客户端已在运行 (PID: $PID)"
                exit 1
            fi
        fi
        echo "启动MISEB FRP Client..."
        nohup "$JAVA_HOME/bin/java" -Xms64m -Xmx256m -Dfile.encoding=UTF-8 -Djava.awt.headless=true -jar miseb-frp-client.jar > "$LOG_FILE" 2>&1 &
        echo $! > "$PID_FILE"
        echo "FRP客户端已启动 (PID: $!)"
        ;;
    stop)
        if [ -f "$PID_FILE" ]; then
            PID=$(cat "$PID_FILE")
            if ps -p $PID > /dev/null 2>&1; then
                echo "停止FRP客户端 (PID: $PID)..."
                kill $PID
                rm -f "$PID_FILE"
                echo "FRP客户端已停止"
            else
                echo "进程不存在，清理PID文件"
                rm -f "$PID_FILE"
            fi
        else
            echo "FRP客户端未运行"
        fi
        ;;
    restart)
        $0 stop
        sleep 2
        $0 start
        ;;
    status)
        if [ -f "$PID_FILE" ]; then
            PID=$(cat "$PID_FILE")
            if ps -p $PID > /dev/null 2>&1; then
                echo "FRP客户端正在运行 (PID: $PID)"
            else
                echo "FRP客户端未运行 (PID文件存在但进程不存在)"
            fi
        else
            echo "FRP客户端未运行"
        fi
        ;;
    *)
        echo "用法: $0 {start|stop|restart|status}"
        exit 1
        ;;
esac
