#!/bin/bash
# ===================================
# MISEB FRP Client 启动脚本 (Linux/Mac)
# 成都艾唯特软件有限公司
# ===================================

cd "$(dirname "$0")"

# 设置JAVA_HOME
export JAVA_HOME="$(pwd)/jre"
export PATH="$JAVA_HOME/bin:$PATH"

# 检查JRE是否存在
if [ ! -f "$JAVA_HOME/bin/java" ]; then
    echo "[错误] 未找到Java运行环境，请确保jre文件夹中包含Java运行时"
    echo "请下载Java 8 JRE并解压到jre文件夹中"
    exit 1
fi

# 检查JAR包是否存在
if [ ! -f "miseb-frp-client.jar" ]; then
    echo "[错误] 未找到miseb-frp-client.jar"
    exit 1
fi

echo "==================================="
echo "  MISEB FRP Client v1.0.0"
echo "  成都艾唯特软件有限公司"
echo "==================================="
echo

# 启动客户端
"$JAVA_HOME/bin/java" -Xms64m -Xmx256m -Dfile.encoding=UTF-8 -jar miseb-frp-client.jar
